/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.base.staticdata.party.PartyRoleEnum;
import cdm.event.common.Affirmation;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="AffirmationBothBuyerAndSellerPartyRolesMustExist")
@ImplementedBy(value=Default.class)
public interface AffirmationBothBuyerAndSellerPartyRolesMustExist
extends Validator<Affirmation> {
    public static final String NAME = "AffirmationBothBuyerAndSellerPartyRolesMustExist";
    public static final String DEFINITION = "if lineage -> tradeReference -> tradableProduct -> product -> security exists then partyRole -> role contains PartyRoleEnum -> Buyer or partyRole -> role contains PartyRoleEnum -> Seller";

    public static class NoOp
    implements AffirmationBothBuyerAndSellerPartyRolesMustExist {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Affirmation affirmation) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements AffirmationBothBuyerAndSellerPartyRolesMustExist {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Affirmation affirmation) {
            ComparisonResult result = this.executeDataRule(affirmation);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)AffirmationBothBuyerAndSellerPartyRolesMustExist.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Affirmation", (RosettaPath)path, (String)AffirmationBothBuyerAndSellerPartyRolesMustExist.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)AffirmationBothBuyerAndSellerPartyRolesMustExist.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Affirmation", (RosettaPath)path, (String)AffirmationBothBuyerAndSellerPartyRolesMustExist.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Affirmation affirmation) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)affirmation).map("getLineage", _affirmation -> _affirmation.getLineage()).mapC("getTradeReference", lineage -> lineage.getTradeReference()).map("Type coercion", referenceWithMetaTrade -> referenceWithMetaTrade.getValue()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getSecurity", product -> product.getSecurity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.contains((Mapper)MapperS.of((Object)affirmation).mapC("getPartyRole", _affirmation -> _affirmation.getPartyRole()).map("getRole", partyRole -> partyRole.getRole()), (Mapper)MapperS.of((Object)((Object)PartyRoleEnum.BUYER))).or(ExpressionOperators.contains((Mapper)MapperS.of((Object)affirmation).mapC("getPartyRole", _affirmation -> _affirmation.getPartyRole()).map("getRole", partyRole -> partyRole.getRole()), (Mapper)MapperS.of((Object)((Object)PartyRoleEnum.SELLER))));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

