/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.processor;

import cdm.base.staticdata.party.PartyRole;
import cdm.base.staticdata.party.PartyRoleEnum;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.Trade;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelatedPartyRoleMappingProcessor
extends MappingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelatedPartyRoleMappingProcessor.class);

    public RelatedPartyRoleMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builder, RosettaModelObjectBuilder parent) {
        Collection<PartyRoleMapping> partyRoleMappings = this.getMappings().stream().filter(m -> m.getXmlValue() != null).filter(m -> synonymPath.getParent().nameStartMatches(m.getXmlPath())).collect(Collectors.groupingBy(this::getKey, Collectors.collectingAndThen(Collectors.toList(), this::toPartyRoleMapping))).values();
        Trade.TradeBuilder tradeBuilder = (Trade.TradeBuilder)parent;
        for (PartyRoleMapping partyRoleMapping : partyRoleMappings) {
            this.getPartyRoleEnum(partyRoleMapping).ifPresent(roleEnum -> {
                PartyRole.PartyRoleBuilder partyRoleBuilder = PartyRole.builder().setRole((PartyRoleEnum)((Object)roleEnum));
                if (partyRoleMapping.partyReference != null) {
                    partyRoleBuilder.setPartyReference(ReferenceWithMetaParty.builder().setExternalReference(partyRoleMapping.partyReference));
                }
                if (partyRoleMapping.ownershipPartyReference != null) {
                    partyRoleBuilder.setOwnershipPartyReference(ReferenceWithMetaParty.builder().setExternalReference(partyRoleMapping.ownershipPartyReference));
                }
                if (partyRoleMapping.partyReferenceMapping != null && partyRoleMapping.partyReferenceModelPath != null) {
                    MappingProcessorUtils.updateMappingSuccess((Mapping)partyRoleMapping.partyReferenceMapping, (RosettaPath)partyRoleMapping.partyReferenceModelPath);
                }
                if (partyRoleMapping.roleMapping != null && partyRoleMapping.roleModelPath != null) {
                    MappingProcessorUtils.updateMappingSuccess((Mapping)partyRoleMapping.roleMapping, (RosettaPath)partyRoleMapping.roleModelPath);
                }
                tradeBuilder.addPartyRole(partyRoleBuilder);
            });
        }
    }

    private Optional<PartyRoleEnum> getPartyRoleEnum(PartyRoleMapping partyRoleMapping) {
        return Optional.ofNullable(partyRoleMapping).map(m -> ((PartyRoleMapping)m).role).flatMap(r -> this.getSynonymToEnumMap().getEnumValueOptional(PartyRoleEnum.class, r));
    }

    private String getKey(Mapping m) {
        int partyTradeInformationIndex = this.getPathIndex(m, "partyTradeInformation");
        int relatedPartyIndex = this.getPathIndex(m, "relatedParty");
        return partyTradeInformationIndex + "-" + relatedPartyIndex;
    }

    private int getPathIndex(Mapping m, String elementName) {
        return MappingProcessorUtils.subPath((String)elementName, (Path)m.getXmlPath()).map(Path::getLastElement).map(Path.PathElement::forceGetIndex).orElse(-1);
    }

    private PartyRoleMapping toPartyRoleMapping(List<Mapping> mappings) {
        try {
            if (!mappings.isEmpty()) {
                String xmlPath = mappings.get(0).getXmlPath().toString();
                Matcher matcher = Pattern.compile(".*partyTradeInformation\\((\\d+)\\).*").matcher(xmlPath);
                if (matcher.find()) {
                    String index = matcher.group(1);
                    Pattern dynamicPattern = Pattern.compile(".*partyTradeInformation\\(" + index + "\\)\\.partyReference.*");
                    Mapping ownershipPartyReferenceMapping = this.getMapping(this.getMappings().stream().filter(m -> m.getXmlValue() != null && dynamicPattern.matcher(m.getXmlPath().toString()).matches()).collect(Collectors.toList()), Path.parse((String)"partyReference.href"));
                    Mapping partyReferenceMapping = this.getMapping(mappings, Path.parse((String)"partyReference.href"));
                    RosettaPath partyReferenceModelPath = this.getModelPath().newSubPath("partyReference").newSubPath("externalReference");
                    Mapping roleMapping = this.getMapping(mappings, Path.parse((String)"role"));
                    RosettaPath roleModelPath = this.getModelPath().newSubPath("role");
                    if (partyReferenceMapping != null && partyReferenceMapping.getXmlValue() != null && roleMapping != null && roleMapping.getXmlValue() != null) {
                        return new PartyRoleMapping(String.valueOf(ownershipPartyReferenceMapping.getXmlValue()), String.valueOf(partyReferenceMapping.getXmlValue()), partyReferenceMapping, partyReferenceModelPath, String.valueOf(roleMapping.getXmlValue()), roleMapping, roleModelPath);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to build party role mapping from mappings {}", mappings, (Object)e);
        }
        return null;
    }

    private Mapping getMapping(List<Mapping> mappings, Path endsWith) {
        return mappings.stream().filter(m -> m.getXmlPath().endsWith(endsWith)).filter(m -> m.getXmlValue() != null).findFirst().orElse(null);
    }

    private static class PartyRoleMapping {
        private final String ownershipPartyReference;
        private final String partyReference;
        private final Mapping partyReferenceMapping;
        private final RosettaPath partyReferenceModelPath;
        private final String role;
        private final Mapping roleMapping;
        private final RosettaPath roleModelPath;

        public PartyRoleMapping(String ownershipPartyReference, String partyReference, Mapping partyReferenceMapping, RosettaPath partyReferenceModelPath, String role, Mapping roleMapping, RosettaPath roleModelPath) {
            this.ownershipPartyReference = ownershipPartyReference;
            this.partyReference = partyReference;
            this.partyReferenceMapping = partyReferenceMapping;
            this.partyReferenceModelPath = partyReferenceModelPath;
            this.role = role;
            this.roleMapping = roleMapping;
            this.roleModelPath = roleModelPath;
        }
    }
}

