/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.processor;

import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.legaldocumentation.common.AgreementName;
import cdm.legaldocumentation.common.ContractualDefinitionsEnum;
import cdm.legaldocumentation.common.ContractualMatrix;
import cdm.legaldocumentation.common.ContractualSupplementTypeEnum;
import cdm.legaldocumentation.common.ContractualTermsSupplement;
import cdm.legaldocumentation.common.LegalAgreement;
import cdm.legaldocumentation.common.LegalAgreementTypeEnum;
import cdm.legaldocumentation.common.MatrixTermEnum;
import cdm.legaldocumentation.common.MatrixTypeEnum;
import cdm.legaldocumentation.common.metafields.FieldWithMetaContractualDefinitionsEnum;
import cdm.legaldocumentation.contract.processor.PartyMappingHelper;
import cdm.legaldocumentation.master.MasterAgreementTypeEnum;
import cdm.legaldocumentation.master.MasterConfirmationAnnexTypeEnum;
import cdm.legaldocumentation.master.MasterConfirmationTypeEnum;
import cdm.product.collateral.CreditSupportAgreementTypeEnum;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.translation.SynonymToEnumMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentationHelper.class);
    private final RosettaPath rosettaPath;
    private final MappingContext mappingContext;
    private final List<Mapping> mappings;
    private final SynonymToEnumMap synonymToEnumMap;
    private final ExecutorService executor;
    private final List<CompletableFuture<?>> invokedTasks;

    public DocumentationHelper(RosettaPath rosettaPath, MappingContext mappingContext) {
        this.rosettaPath = rosettaPath;
        this.mappingContext = mappingContext;
        this.mappings = mappingContext.getMappings();
        this.executor = mappingContext.getExecutor();
        this.invokedTasks = mappingContext.getInvokedTasks();
        this.synonymToEnumMap = mappingContext.getSynonymToEnumMap();
    }

    public List<LegalAgreement> getDocumentation(Path synonymPath) {
        ArrayList<LegalAgreement> documentation = new ArrayList<LegalAgreement>();
        this.getMasterAgreement(synonymPath).ifPresent(documentation::add);
        this.getMasterConfirmation(synonymPath).ifPresent(documentation::add);
        this.getBrokerConfirmation(synonymPath).ifPresent(documentation::add);
        this.getCreditSupportAgreement(synonymPath).ifPresent(documentation::add);
        this.getConfirmation(synonymPath).ifPresent(documentation::add);
        this.getOtherAgreement(synonymPath).ifPresent(documentation::add);
        return documentation;
    }

    private Optional<LegalAgreement> getMasterAgreement(Path synonymPath) {
        Path masterAgreementPath = synonymPath.addElement("masterAgreement");
        LegalAgreement.LegalAgreementBuilder builder = LegalAgreement.builder();
        Path masterAgreementTypePath = masterAgreementPath.addElement("masterAgreementType");
        MappingProcessorUtils.setValueAndUpdateMappings((Path)masterAgreementTypePath, xmlValue -> {
            AgreementName.AgreementNameBuilder agreementName = builder.getOrCreateLegalAgreementIdentification().getOrCreateAgreementName();
            this.synonymToEnumMap.getEnumValueOptional(MasterAgreementTypeEnum.class, xmlValue).ifPresent(agreementName::setMasterAgreementTypeValue);
        }, this.mappings, (RosettaPath)this.rosettaPath);
        MappingProcessorUtils.setValueAndUpdateMappings((Path)masterAgreementTypePath.addElement("masterAgreementTypeScheme"), xmlValue -> {
            AgreementName.AgreementNameBuilder agreementName = builder.getOrCreateLegalAgreementIdentification().getOrCreateAgreementName();
            agreementName.getOrCreateMasterAgreementType().getOrCreateMeta().setScheme(xmlValue);
        }, this.mappings, (RosettaPath)this.rosettaPath);
        MappingProcessorUtils.setValueAndUpdateMappings((Path)masterAgreementPath.addElement("masterAgreementVersion"), xmlValue -> builder.getOrCreateLegalAgreementIdentification().setVintage(Integer.valueOf(xmlValue)), this.mappings, (RosettaPath)this.rosettaPath);
        MappingProcessorUtils.setValueAndUpdateMappings((Path)masterAgreementPath.addElement("masterAgreementDate"), xmlValue -> builder.setAgreementDate(this.parseDate((String)xmlValue)), this.mappings, (RosettaPath)this.rosettaPath);
        if (builder.hasData()) {
            this.setContractualParty(builder);
        }
        return this.setAgreementType(builder, LegalAgreementTypeEnum.MASTER_AGREEMENT);
    }

    private Optional<LegalAgreement> getMasterConfirmation(Path synonymPath) {
        Path masterConfirmationPath = synonymPath.addElement("masterConfirmation");
        LegalAgreement.LegalAgreementBuilder builder = LegalAgreement.builder();
        Path masterConfirmationTypePath = masterConfirmationPath.addElement("masterConfirmationType");
        MappingProcessorUtils.setValueAndUpdateMappings((Path)masterConfirmationTypePath, xmlValue -> {
            AgreementName.AgreementNameBuilder agreementName = builder.getOrCreateLegalAgreementIdentification().getOrCreateAgreementName();
            this.synonymToEnumMap.getEnumValueOptional(MasterConfirmationTypeEnum.class, xmlValue).ifPresent(agreementName::setMasterConfirmationTypeValue);
        }, this.mappings, (RosettaPath)this.rosettaPath);
        MappingProcessorUtils.setValueAndUpdateMappings((Path)masterConfirmationTypePath.addElement("masterConfirmationTypeScheme"), xmlValue -> {
            AgreementName.AgreementNameBuilder agreementName = builder.getOrCreateLegalAgreementIdentification().getOrCreateAgreementName();
            agreementName.getOrCreateMasterConfirmationType().getOrCreateMeta().setScheme(xmlValue);
        }, this.mappings, (RosettaPath)this.rosettaPath);
        Path masterConfirmationAnnexTypePath = masterConfirmationPath.addElement("masterConfirmationAnnexType");
        MappingProcessorUtils.setValueAndUpdateMappings((Path)masterConfirmationAnnexTypePath, xmlValue -> {
            AgreementName.AgreementNameBuilder agreementName = builder.getOrCreateLegalAgreementIdentification().getOrCreateAgreementName();
            this.synonymToEnumMap.getEnumValueOptional(MasterConfirmationAnnexTypeEnum.class, xmlValue).ifPresent(agreementName::setMasterConfirmationAnnexTypeValue);
        }, this.mappings, (RosettaPath)this.rosettaPath);
        MappingProcessorUtils.setValueAndUpdateMappings((Path)masterConfirmationAnnexTypePath.addElement("masterConfirmationAnnexTypeScheme"), xmlValue -> {
            AgreementName.AgreementNameBuilder agreementName = builder.getOrCreateLegalAgreementIdentification().getOrCreateAgreementName();
            agreementName.getOrCreateMasterConfirmationAnnexType().getOrCreateMeta().setScheme(xmlValue);
        }, this.mappings, (RosettaPath)this.rosettaPath);
        MappingProcessorUtils.setValueAndUpdateMappings((Path)masterConfirmationPath.addElement("masterConfirmationDate"), xmlValue -> builder.setAgreementDate(this.parseDate((String)xmlValue)), this.mappings, (RosettaPath)this.rosettaPath);
        if (builder.hasData()) {
            this.setContractualParty(builder);
        }
        return this.setAgreementType(builder, LegalAgreementTypeEnum.MASTER_CONFIRMATION);
    }

    private Optional<LegalAgreement> getBrokerConfirmation(Path synonymPath) {
        LegalAgreement.LegalAgreementBuilder builder = LegalAgreement.builder();
        if (builder.hasData()) {
            this.setContractualParty(builder);
        }
        return this.setAgreementType(builder, LegalAgreementTypeEnum.BROKER_CONFIRMATION);
    }

    private Optional<LegalAgreement> getCreditSupportAgreement(Path synonymPath) {
        Path creditSupportAgreementPath = synonymPath.addElement("creditSupportAgreement");
        LegalAgreement.LegalAgreementBuilder builder = LegalAgreement.builder();
        Path creditSupportAgreementTypePath = creditSupportAgreementPath.addElement("type");
        MappingProcessorUtils.setValueAndUpdateMappings((Path)creditSupportAgreementTypePath, xmlValue -> {
            AgreementName.AgreementNameBuilder agreementName = builder.getOrCreateLegalAgreementIdentification().getOrCreateAgreementName();
            this.synonymToEnumMap.getEnumValueOptional(CreditSupportAgreementTypeEnum.class, xmlValue).ifPresent(agreementName::setCreditSupportAgreementTypeValue);
        }, this.mappings, (RosettaPath)this.rosettaPath);
        MappingProcessorUtils.setValueAndUpdateMappings((Path)creditSupportAgreementTypePath.addElement("creditSupportAgreementTypeScheme"), xmlValue -> {
            AgreementName.AgreementNameBuilder agreementName = builder.getOrCreateLegalAgreementIdentification().getOrCreateAgreementName();
            agreementName.getOrCreateCreditSupportAgreementType().getOrCreateMeta().setScheme(xmlValue);
        }, this.mappings, (RosettaPath)this.rosettaPath);
        MappingProcessorUtils.setValueAndUpdateMappings((Path)creditSupportAgreementPath.addElement("date"), xmlValue -> builder.setAgreementDate(this.parseDate((String)xmlValue)), this.mappings, (RosettaPath)this.rosettaPath);
        if (builder.hasData()) {
            this.setContractualParty(builder);
        }
        return this.setAgreementType(builder, LegalAgreementTypeEnum.CREDIT_SUPPORT_AGREEMENT);
    }

    private Optional<LegalAgreement> getConfirmation(Path synonymPath) {
        LegalAgreement.LegalAgreementBuilder builder = LegalAgreement.builder();
        MappingProcessorUtils.filterListMappings(this.mappings, (Path)synonymPath.addElement("contractualDefinitions")).stream().filter(m -> m.getXmlValue() != null).forEach(m -> {
            FieldWithMetaContractualDefinitionsEnum.FieldWithMetaContractualDefinitionsEnumBuilder contractualDefinitionsBuilder = FieldWithMetaContractualDefinitionsEnum.builder();
            Path contractualDefinitionsPath = m.getXmlPath();
            MappingProcessorUtils.setValueAndUpdateMappings((Path)contractualDefinitionsPath, xmlValue -> this.synonymToEnumMap.getEnumValueOptional(ContractualDefinitionsEnum.class, xmlValue).ifPresent(contractualDefinitionsBuilder::setValue), this.mappings, (RosettaPath)this.rosettaPath);
            MappingProcessorUtils.setValueAndUpdateMappings((Path)contractualDefinitionsPath.addElement("contractualDefinitionsScheme"), xmlValue -> contractualDefinitionsBuilder.getOrCreateMeta().setScheme(xmlValue), this.mappings, (RosettaPath)this.rosettaPath);
            if (contractualDefinitionsBuilder.hasData()) {
                builder.getOrCreateLegalAgreementIdentification().getOrCreateAgreementName().addContractualDefinitionsType(contractualDefinitionsBuilder);
            }
        });
        MappingProcessorUtils.filterListMappings(this.mappings, (Path)synonymPath.addElement("contractualMatrix")).forEach(m -> {
            AgreementName.AgreementNameBuilder agreementName = builder.getOrCreateLegalAgreementIdentification().getOrCreateAgreementName();
            ContractualMatrix.ContractualMatrixBuilder contractualMatrixBuilder = ContractualMatrix.builder();
            Path matrixTypePath = m.getXmlPath().addElement("matrixType");
            MappingProcessorUtils.setValueAndUpdateMappings((Path)matrixTypePath, xmlValue -> this.synonymToEnumMap.getEnumValueOptional(MatrixTypeEnum.class, xmlValue).ifPresent(contractualMatrixBuilder::setMatrixTypeValue), this.mappings, (RosettaPath)this.rosettaPath);
            MappingProcessorUtils.setValueAndUpdateMappings((Path)matrixTypePath.addElement("matrixTypeScheme"), xmlValue -> contractualMatrixBuilder.getOrCreateMatrixType().getOrCreateMeta().setScheme(xmlValue), this.mappings, (RosettaPath)this.rosettaPath);
            Path matrixTermPath = m.getXmlPath().addElement("matrixTerm");
            MappingProcessorUtils.setValueAndUpdateMappings((Path)matrixTermPath, xmlValue -> this.synonymToEnumMap.getEnumValueOptional(MatrixTermEnum.class, xmlValue).ifPresent(contractualMatrixBuilder::setMatrixTermValue), this.mappings, (RosettaPath)this.rosettaPath);
            MappingProcessorUtils.setValueAndUpdateMappings((Path)matrixTermPath.addElement("matrixTermScheme"), xmlValue -> contractualMatrixBuilder.getOrCreateMatrixTerm().getOrCreateMeta().setScheme(xmlValue), this.mappings, (RosettaPath)this.rosettaPath);
            if (contractualMatrixBuilder.hasData()) {
                agreementName.addContractualMatrix(contractualMatrixBuilder);
            }
        });
        MappingProcessorUtils.filterListMappings(this.mappings, (Path)synonymPath.addElement("contractualTermsSupplement")).forEach(m -> {
            AgreementName.AgreementNameBuilder agreementName = builder.getOrCreateLegalAgreementIdentification().getOrCreateAgreementName();
            ContractualTermsSupplement.ContractualTermsSupplementBuilder contractualTermsSupplementBuilder = ContractualTermsSupplement.builder();
            Path typePath = m.getXmlPath().addElement("type");
            MappingProcessorUtils.setValueAndUpdateMappings((Path)typePath, xmlValue -> this.synonymToEnumMap.getEnumValueOptional(ContractualSupplementTypeEnum.class, xmlValue).ifPresent(contractualTermsSupplementBuilder::setContractualTermsSupplementTypeValue), this.mappings, (RosettaPath)this.rosettaPath);
            MappingProcessorUtils.setValueAndUpdateMappings((Path)typePath.addElement("contractualSupplementScheme"), xmlValue -> contractualTermsSupplementBuilder.getOrCreateContractualTermsSupplementType().getOrCreateMeta().setScheme(xmlValue), this.mappings, (RosettaPath)this.rosettaPath);
            MappingProcessorUtils.setValueAndUpdateMappings((Path)m.getXmlPath().addElement("publicationDate"), xmlValue -> contractualTermsSupplementBuilder.setPublicationDate(this.parseDate((String)xmlValue)), this.mappings, (RosettaPath)this.rosettaPath);
            if (contractualTermsSupplementBuilder.hasData()) {
                agreementName.addContractualTermsSupplement(contractualTermsSupplementBuilder);
            }
        });
        if (builder.hasData()) {
            this.setContractualParty(builder);
        }
        return this.setAgreementType(builder, LegalAgreementTypeEnum.CONFIRMATION);
    }

    private Date parseDate(String xmlValue) {
        return Date.parse((String)xmlValue.replace("Z", ""));
    }

    private Optional<LegalAgreement> getOtherAgreement(Path synonymPath) {
        Path otherAgreementPath = synonymPath.addElement("otherAgreement");
        LegalAgreement.LegalAgreementBuilder builder = LegalAgreement.builder();
        MappingProcessorUtils.setValueAndUpdateMappings((Path)otherAgreementPath.addElement("type"), xmlValue -> builder.getOrCreateLegalAgreementIdentification().getOrCreateAgreementName().setOtherAgreement((String)xmlValue), this.mappings, (RosettaPath)this.rosettaPath);
        MappingProcessorUtils.setValueAndUpdateMappings((Path)otherAgreementPath.addElement("version"), xmlValue -> builder.getOrCreateLegalAgreementIdentification().setVintage(Integer.valueOf(xmlValue)), this.mappings, (RosettaPath)this.rosettaPath);
        MappingProcessorUtils.setValueAndUpdateMappings((Path)otherAgreementPath.addElement("date"), xmlValue -> builder.setAgreementDate(this.parseDate((String)xmlValue)), this.mappings, (RosettaPath)this.rosettaPath);
        if (builder.hasData()) {
            this.setContractualParty(builder);
        }
        return this.setAgreementType(builder, LegalAgreementTypeEnum.OTHER);
    }

    private Optional<LegalAgreement> setAgreementType(LegalAgreement.LegalAgreementBuilder builder, LegalAgreementTypeEnum masterAgreement) {
        if (builder.hasData()) {
            builder.getOrCreateLegalAgreementIdentification().getOrCreateAgreementName().setAgreementType(masterAgreement);
            return Optional.of(builder);
        }
        return Optional.empty();
    }

    private void setContractualParty(LegalAgreement.LegalAgreementBuilder builder) {
        PartyMappingHelper.getInstance(this.mappingContext).ifPresent(helper -> {
            LOGGER.debug("Waiting for counterparties to be collected before updating contractual parties");
            this.invokedTasks.add((CompletableFuture<?>)helper.getBothCounterpartiesCollectedFuture().thenAcceptAsync(counterpartyMap -> {
                Set counterpartyExternalRefs = counterpartyMap.keySet();
                LOGGER.info("Setting contractual party references {}", counterpartyExternalRefs);
                List contractualParties = counterpartyExternalRefs.stream().map(counterpartyRef -> ReferenceWithMetaParty.builder().setExternalReference((String)counterpartyRef)).collect(Collectors.toList());
                builder.setContractualParty(contractualParties);
            }, (Executor)this.executor));
        });
    }
}

