/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.QuantitySchedule;
import cdm.base.math.functions.FilterQuantityByFinancialUnit;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.Reset;
import cdm.event.common.TradeState;
import cdm.event.common.Transfer;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.functions.FixedAmount;
import cdm.product.asset.functions.FloatingAmount;
import cdm.product.collateral.Collateral;
import cdm.product.collateral.EligibleCollateralCriteria;
import cdm.product.common.schedule.CalculationPeriodData;
import cdm.product.common.schedule.functions.CalculationPeriodRange;
import cdm.product.template.AssetPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaDate;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ResolveSecurityFinanceBillingAmountDefault.class)
public abstract class ResolveSecurityFinanceBillingAmount
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CalculationPeriodRange calculationPeriodRange0;
    @Inject
    protected ExtractCounterpartyByRole extractCounterpartyByRole;
    @Inject
    protected FilterQuantityByFinancialUnit filterQuantityByFinancialUnit;
    @Inject
    protected FixedAmount fixedAmount;
    @Inject
    protected FloatingAmount floatingAmount;

    public Transfer evaluate(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
        Transfer transfer;
        Transfer.TransferBuilder transferBuilder = this.doEvaluate(tradeState, reset, recordStartDate, recordEndDate, transferDate);
        if (transferBuilder == null) {
            transfer = null;
        } else {
            transfer = transferBuilder.build();
            this.objectValidator.validate(Transfer.class, (RosettaModelObject)transfer);
        }
        return transfer;
    }

    protected abstract Transfer.TransferBuilder doEvaluate(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract MapperS<? extends QuantitySchedule> securityQuantity(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract MapperS<? extends InterestRatePayout> interestRatePayout(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract MapperS<? extends AssetPayout> assetPayout(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract MapperS<? extends Collateral> collateral(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract MapperS<BigDecimal> haircutPercentage(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract MapperS<BigDecimal> valuationPercentage(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract MapperS<BigDecimal> marginRatio(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract MapperS<BigDecimal> billingQuantity(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract MapperS<? extends CalculationPeriodData> calculationPeriodRange1(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract MapperS<BigDecimal> performance(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract MapperS<? extends ReferenceWithMetaParty> payerPartyReference(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract MapperS<? extends ReferenceWithMetaParty> receiverPartyReference(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    public static class ResolveSecurityFinanceBillingAmountDefault
    extends ResolveSecurityFinanceBillingAmount {
        @Override
        protected Transfer.TransferBuilder doEvaluate(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            Transfer.TransferBuilder transfer = Transfer.builder();
            return this.assignOutput(transfer, tradeState, reset, recordStartDate, recordEndDate, transferDate);
        }

        protected Transfer.TransferBuilder assignOutput(Transfer.TransferBuilder transfer, TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            transfer.getOrCreateQuantity().setValue((BigDecimal)this.performance(tradeState, reset, recordStartDate, recordEndDate, transferDate).get());
            transfer.getOrCreateQuantity().getOrCreateUnit().setCurrency((FieldWithMetaString)this.interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).map("getPriceQuantity", _interestRatePayout -> _interestRatePayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get());
            ReferenceWithMetaParty ifThenElseResult0 = ExpressionOperators.greaterThanEquals(this.performance(tradeState, reset, recordStartDate, recordEndDate, transferDate), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (ReferenceWithMetaParty)this.payerPartyReference(tradeState, reset, recordStartDate, recordEndDate, transferDate).get() : (ReferenceWithMetaParty)this.receiverPartyReference(tradeState, reset, recordStartDate, recordEndDate, transferDate).get();
            transfer.getOrCreatePayerReceiver().setPayerPartyReference(ifThenElseResult0);
            ReferenceWithMetaParty ifThenElseResult1 = ExpressionOperators.greaterThanEquals(this.performance(tradeState, reset, recordStartDate, recordEndDate, transferDate), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (ReferenceWithMetaParty)this.receiverPartyReference(tradeState, reset, recordStartDate, recordEndDate, transferDate).get() : (ReferenceWithMetaParty)this.payerPartyReference(tradeState, reset, recordStartDate, recordEndDate, transferDate).get();
            transfer.getOrCreatePayerReceiver().setReceiverPartyReference(ifThenElseResult1);
            transfer.getOrCreateSettlementDate().setAdjustedDate(transferDate == null ? FieldWithMetaDate.builder().build() : FieldWithMetaDate.builder().setValue(transferDate).build());
            return Optional.ofNullable(transfer).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends QuantitySchedule> securityQuantity(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperS.of((Object)((QuantitySchedule)MapperC.of(this.filterQuantityByFinancialUnit.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).getMulti(), FinancialUnitEnum.SHARE)).get()));
        }

        @Override
        protected MapperS<? extends InterestRatePayout> interestRatePayout(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperS.of((Object)((InterestRatePayout)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get()));
        }

        @Override
        protected MapperS<? extends AssetPayout> assetPayout(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperS.of((Object)((AssetPayout)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getCollateral", economicTerms -> economicTerms.getCollateral()).mapC("getCollateralPortfolio", _collateral -> _collateral.getCollateralPortfolio()).map("Type coercion", referenceWithMetaCollateralPortfolio -> referenceWithMetaCollateralPortfolio.getValue()).mapC("getCollateralPosition", collateralPortfolio -> collateralPortfolio.getCollateralPosition()).map("getProduct", collateralPosition -> collateralPosition.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getAssetPayout", payout -> payout.getAssetPayout()).get()));
        }

        @Override
        protected MapperS<? extends Collateral> collateral(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getCollateral", economicTerms -> economicTerms.getCollateral());
        }

        @Override
        protected MapperS<BigDecimal> haircutPercentage(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperMaths.subtract((Mapper)MapperS.of((Object)new BigDecimal("1.0")), (Mapper)MapperS.of((Object)((EligibleCollateralCriteria)this.collateral(tradeState, reset, recordStartDate, recordEndDate, transferDate).map("getCollateralProvisions", _collateral -> _collateral.getCollateralProvisions()).mapC("getEligibleCollateral", collateralProvisions -> collateralProvisions.getEligibleCollateral()).get())).map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).map("getValuationTreatment", collateralTreatment -> collateralTreatment.getValuationTreatment()).map("getHaircutPercentage", collateralValuationTreatment -> collateralValuationTreatment.getHaircutPercentage()));
        }

        @Override
        protected MapperS<BigDecimal> valuationPercentage(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperMaths.divide((Mapper)MapperS.of((Object)BigDecimal.valueOf(1L)), this.haircutPercentage(tradeState, reset, recordStartDate, recordEndDate, transferDate));
        }

        @Override
        protected MapperS<BigDecimal> marginRatio(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((EligibleCollateralCriteria)this.collateral(tradeState, reset, recordStartDate, recordEndDate, transferDate).map("getCollateralProvisions", _collateral -> _collateral.getCollateralProvisions()).mapC("getEligibleCollateral", collateralProvisions -> collateralProvisions.getEligibleCollateral()).get())).map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).map("getValuationTreatment", collateralTreatment -> collateralTreatment.getValuationTreatment()).map("getHaircutPercentage", collateralValuationTreatment -> collateralValuationTreatment.getHaircutPercentage())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.valuationPercentage(tradeState, reset, recordStartDate, recordEndDate, transferDate);
            }
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((EligibleCollateralCriteria)this.collateral(tradeState, reset, recordStartDate, recordEndDate, transferDate).map("getCollateralProvisions", _collateral -> _collateral.getCollateralProvisions()).mapC("getEligibleCollateral", collateralProvisions -> collateralProvisions.getEligibleCollateral()).get())).map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).map("getValuationTreatment", collateralTreatment -> collateralTreatment.getValuationTreatment()).map("getMarginPercentage", collateralValuationTreatment -> collateralValuationTreatment.getMarginPercentage())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((EligibleCollateralCriteria)this.collateral(tradeState, reset, recordStartDate, recordEndDate, transferDate).map("getCollateralProvisions", _collateral -> _collateral.getCollateralProvisions()).mapC("getEligibleCollateral", collateralProvisions -> collateralProvisions.getEligibleCollateral()).get())).map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).map("getValuationTreatment", collateralTreatment -> collateralTreatment.getValuationTreatment()).map("getMarginPercentage", collateralValuationTreatment -> collateralValuationTreatment.getMarginPercentage());
            }
            return MapperS.of((Object)new BigDecimal("1.0"));
        }

        @Override
        protected MapperS<BigDecimal> billingQuantity(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperMaths.multiply((Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)reset).map("getResetValue", _reset -> _reset.getResetValue()).map("getValue", price -> price.getValue()), (Mapper)this.securityQuantity(tradeState, reset, recordStartDate, recordEndDate, transferDate).map("getValue", quantitySchedule -> quantitySchedule.getValue())), this.marginRatio(tradeState, reset, recordStartDate, recordEndDate, transferDate));
        }

        @Override
        protected MapperS<? extends CalculationPeriodData> calculationPeriodRange1(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperS.of((Object)this.calculationPeriodRange0.evaluate(recordStartDate, recordEndDate, null));
        }

        @Override
        protected MapperS<BigDecimal> performance(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            if (ExpressionOperators.exists((Mapper)this.interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.fixedAmount.evaluate((InterestRatePayout)this.interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).get(), (BigDecimal)this.billingQuantity(tradeState, reset, recordStartDate, recordEndDate, transferDate).get(), recordEndDate, (CalculationPeriodData)this.calculationPeriodRange1(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()));
            }
            if (ExpressionOperators.exists((Mapper)this.interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.floatingAmount.evaluate((InterestRatePayout)this.interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).get(), (BigDecimal)MapperS.of((Object)reset).map("getResetValue", _reset -> _reset.getResetValue()).map("getValue", price -> price.getValue()).get(), (BigDecimal)this.billingQuantity(tradeState, reset, recordStartDate, recordEndDate, transferDate).get(), recordEndDate, (CalculationPeriodData)this.calculationPeriodRange1(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()));
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<? extends ReferenceWithMetaParty> payerPartyReference(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)this.interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).map("getPayerReceiver", _interestRatePayout -> _interestRatePayout.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference());
        }

        @Override
        protected MapperS<? extends ReferenceWithMetaParty> receiverPartyReference(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)this.interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).map("getPayerReceiver", _interestRatePayout -> _interestRatePayout.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference());
        }
    }
}

