# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['MasterAgreementClauseVariant']


class MasterAgreementClauseVariant(BaseDataClass):
  """
  Sets the details for a specific variant associated to a clause in a Master Agreement
  """
  identifier: MasterAgreementVariantIdentifierEnum = Field(..., description="Unique identifier for this variant")
  """
  Unique identifier for this variant
  """
  name: Optional[str] = Field(None, description="Optional textual description of the variant.")
  """
  Optional textual description of the variant.
  """
  counterparty: List[CounterpartyRoleEnum] = Field([], description="Optional counterparty role. This can be used where a clause needs to assign a different variant to the different parties on the agreement based upon their role i.e. Party A or Party B.")
  """
  Optional counterparty role. This can be used where a clause needs to assign a different variant to the different parties on the agreement based upon their role i.e. Party A or Party B.
  """
  @rosetta_condition
  def cardinality_counterparty(self):
    return check_cardinality(self.counterparty, 0, 2)
  
  otherParty: List[PartyRoleEnum] = Field([], description="Optional party. This can be used where a clause needs to assign different variants to different parties who may or may not be on the agreement.")
  """
  Optional party. This can be used where a clause needs to assign different variants to different parties who may or may not be on the agreement.
  """
  variableSet: List[MasterAgreementVariableSet] = Field([], description="For some variants of some clauses additional details are required to work out what has been elected. This array can be used to define the name and value of these variables. Please refer to the agreement documentation for more details of the variables that are available for any clause.")
  """
  For some variants of some clauses additional details are required to work out what has been elected. This array can be used to define the name and value of these variables. Please refer to the agreement documentation for more details of the variables that are available for any clause.
  """

from cdm.legaldocumentation.master.MasterAgreementVariantIdentifierEnum import MasterAgreementVariantIdentifierEnum
from cdm.base.staticdata.party.CounterpartyRoleEnum import CounterpartyRoleEnum
from cdm.base.staticdata.party.PartyRoleEnum import PartyRoleEnum
from cdm.legaldocumentation.master.MasterAgreementVariableSet import MasterAgreementVariableSet

MasterAgreementClauseVariant.update_forward_refs()
