/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="PayoutNotionalResetOnPerformancePayout")
@ImplementedBy(value=Default.class)
public interface PayoutNotionalResetOnPerformancePayout
extends Validator<Payout> {
    public static final String NAME = "PayoutNotionalResetOnPerformancePayout";
    public static final String DEFINITION = "interestRatePayout -> priceQuantity -> reset is absent and creditDefaultPayout -> priceQuantity -> reset is absent and optionPayout -> priceQuantity -> reset is absent and cashflow -> priceQuantity -> reset is absent";

    public ValidationResult<Payout> validate(RosettaPath var1, Payout var2);

    public static class NoOp
    implements PayoutNotionalResetOnPerformancePayout {
        @Override
        public ValidationResult<Payout> validate(RosettaPath path, Payout payout) {
            return ValidationResult.success((String)PayoutNotionalResetOnPerformancePayout.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutNotionalResetOnPerformancePayout.DEFINITION);
        }
    }

    public static class Default
    implements PayoutNotionalResetOnPerformancePayout {
        @Override
        public ValidationResult<Payout> validate(RosettaPath path, Payout payout) {
            ComparisonResult result = this.executeDataRule(payout);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PayoutNotionalResetOnPerformancePayout.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutNotionalResetOnPerformancePayout.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PayoutNotionalResetOnPerformancePayout failed.";
            }
            return ValidationResult.failure((String)PayoutNotionalResetOnPerformancePayout.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutNotionalResetOnPerformancePayout.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Payout payout) {
            try {
                ComparisonResult result = ExpressionOperators.notExists((Mapper)MapperS.of((Object)payout).mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout()).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()).map("getReset", resolvablePriceQuantity -> resolvablePriceQuantity.getReset())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)payout).map("getCreditDefaultPayout", _payout -> _payout.getCreditDefaultPayout()).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()).map("getReset", resolvablePriceQuantity -> resolvablePriceQuantity.getReset()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)payout).mapC("getOptionPayout", _payout -> _payout.getOptionPayout()).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()).map("getReset", resolvablePriceQuantity -> resolvablePriceQuantity.getReset()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)payout).mapC("getCashflow", _payout -> _payout.getCashflow()).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()).map("getReset", resolvablePriceQuantity -> resolvablePriceQuantity.getReset())));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

