/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.processor;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.legaldocumentation.contract.processor.PartyMappingHelper;
import cdm.product.template.FixedPricePayout;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.util.CollectionUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DividendFixedLegMappingProcessor
extends MappingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DividendFixedLegMappingProcessor.class);

    public DividendFixedLegMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builders, RosettaModelObjectBuilder parent) {
        AtomicInteger index = new AtomicInteger(0);
        CollectionUtils.emptyIfNull(builders).stream().filter(RosettaModelObjectBuilder::hasData).forEach(fixedPricePayout -> this.mapFixedPricePayoutPayerReceiver(synonymPath.getParent(), this.getModelPath().withIndex(index.getAndIncrement()).newSubPath("payerReceiver"), (FixedPricePayout.FixedPricePayoutBuilder)fixedPricePayout));
    }

    private void mapFixedPricePayoutPayerReceiver(Path dividendLegSynonymPath, RosettaPath payerReceiverModelPath, FixedPricePayout.FixedPricePayoutBuilder fixedPricePayout) {
        LOGGER.debug("Mapping FixedPricePayout.payerReceiver [synonymPath={}, modelPath={}]", (Object)dividendLegSynonymPath, (Object)payerReceiverModelPath);
        PartyMappingHelper.getInstance(this.getContext()).ifPresent(helper -> {
            PayerReceiver.PayerReceiverBuilder payerReceiver = fixedPricePayout.getOrCreatePayerReceiver();
            helper.setCounterpartyRoleEnum(payerReceiverModelPath.newSubPath("payer"), dividendLegSynonymPath.addElement("payerPartyReference"), payerReceiver::setPayer);
            helper.setCounterpartyRoleEnum(payerReceiverModelPath.newSubPath("receiver"), dividendLegSynonymPath.addElement("receiverPartyReference"), payerReceiver::setReceiver);
        });
    }
}

