/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="DeterminationMethodEnum")
public enum DeterminationMethodEnum {
    AGREED_INITIAL_PRICE("AgreedInitialPrice"),
    AS_SPECIFIED_IN_MASTER_CONFIRMATION("AsSpecifiedInMasterConfirmation"),
    CALCULATION_AGENT("CalculationAgent"),
    CLOSING_PRICE("ClosingPrice"),
    DIVIDEND_CURRENCY("DividendCurrency"),
    EXPIRING_CONTRACT_LEVEL("ExpiringContractLevel"),
    HEDGE_EXECUTION("HedgeExecution"),
    ISSUER_PAYMENT_CURRENCY("IssuerPaymentCurrency"),
    NAV("NAV"),
    OPEN_PRICE("OpenPrice"),
    OSP_PRICE("OSPPrice"),
    SETTLEMENT_CURRENCY("SettlementCurrency"),
    STRIKE_DATE_DETERMINATION("StrikeDateDetermination"),
    TWAP_PRICE("TWAPPrice"),
    VALUATION_TIME("ValuationTime"),
    VWAP_PRICE("VWAPPrice");

    private static Map<String, DeterminationMethodEnum> values;
    private final String rosettaName;
    private final String displayName;

    private DeterminationMethodEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private DeterminationMethodEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static DeterminationMethodEnum fromDisplayName(String name) {
        DeterminationMethodEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, DeterminationMethodEnum> map = new ConcurrentHashMap<String, DeterminationMethodEnum>();
        for (DeterminationMethodEnum instance : DeterminationMethodEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

