/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.observable.asset.PriceComposite;
import cdm.observable.asset.PriceOperandEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="PriceCompositeArithmeticOperator")
@ImplementedBy(value=Default.class)
public interface PriceCompositeArithmeticOperator
extends Validator<PriceComposite> {
    public static final String NAME = "PriceCompositeArithmeticOperator";
    public static final String DEFINITION = "if operandType = PriceOperandEnum -> ForwardPoint or operandType = PriceOperandEnum -> AccruedInterest then arithmeticOperator = ArithmeticOperationEnum -> Add or arithmeticOperator = ArithmeticOperationEnum -> Subtract";

    public ValidationResult<PriceComposite> validate(RosettaPath var1, PriceComposite var2);

    public static class NoOp
    implements PriceCompositeArithmeticOperator {
        @Override
        public ValidationResult<PriceComposite> validate(RosettaPath path, PriceComposite priceComposite) {
            return ValidationResult.success((String)PriceCompositeArithmeticOperator.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceComposite", (RosettaPath)path, (String)PriceCompositeArithmeticOperator.DEFINITION);
        }
    }

    public static class Default
    implements PriceCompositeArithmeticOperator {
        @Override
        public ValidationResult<PriceComposite> validate(RosettaPath path, PriceComposite priceComposite) {
            ComparisonResult result = this.executeDataRule(priceComposite);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PriceCompositeArithmeticOperator.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceComposite", (RosettaPath)path, (String)PriceCompositeArithmeticOperator.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PriceCompositeArithmeticOperator failed.";
            }
            return ValidationResult.failure((String)PriceCompositeArithmeticOperator.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceComposite", (RosettaPath)path, (String)PriceCompositeArithmeticOperator.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(PriceComposite priceComposite) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)priceComposite).map("getOperandType", _priceComposite -> _priceComposite.getOperandType()), (Mapper)MapperS.of((Object)((Object)PriceOperandEnum.FORWARD_POINT)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)priceComposite).map("getOperandType", _priceComposite -> _priceComposite.getOperandType()), (Mapper)MapperS.of((Object)((Object)PriceOperandEnum.ACCRUED_INTEREST)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)priceComposite).map("getArithmeticOperator", _priceComposite -> _priceComposite.getArithmeticOperator()), (Mapper)MapperS.of((Object)((Object)ArithmeticOperationEnum.ADD)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)priceComposite).map("getArithmeticOperator", _priceComposite -> _priceComposite.getArithmeticOperator()), (Mapper)MapperS.of((Object)((Object)ArithmeticOperationEnum.SUBTRACT)), (CardinalityOperator)CardinalityOperator.All));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

