/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.metafields.FieldWithMetaCommodity;
import cdm.base.staticdata.asset.common.metafields.FieldWithMetaProductIdentifier;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.OptionReferenceTypeEnum;
import cdm.observable.asset.QuotedCurrencyPair;
import cdm.observable.asset.meta.ObservableMeta;
import cdm.observable.asset.metafields.FieldWithMetaFloatingRateOption;
import cdm.observable.asset.metafields.FieldWithMetaQuotedCurrencyPair;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.Key;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Observable", builder=ObservableBuilderImpl.class, version="5.0.0")
public interface Observable
extends RosettaModelObject,
GlobalKey {
    public static final ObservableMeta metaData = new ObservableMeta();

    public FieldWithMetaFloatingRateOption getRateOption();

    public FieldWithMetaCommodity getCommodity();

    public List<? extends FieldWithMetaProductIdentifier> getProductIdentifier();

    public FieldWithMetaQuotedCurrencyPair getCurrencyPair();

    public OptionReferenceTypeEnum getOptionReferenceType();

    public MetaFields getMeta();

    public Observable build();

    public ObservableBuilder toBuilder();

    public static ObservableBuilder builder() {
        return new ObservableBuilderImpl();
    }

    default public RosettaMetaData<? extends Observable> metaData() {
        return metaData;
    }

    default public Class<? extends Observable> getType() {
        return Observable.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("optionReferenceType"), OptionReferenceTypeEnum.class, (Object)this.getOptionReferenceType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rateOption"), processor, FieldWithMetaFloatingRateOption.class, this.getRateOption(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodity"), processor, FieldWithMetaCommodity.class, this.getCommodity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productIdentifier"), processor, FieldWithMetaProductIdentifier.class, this.getProductIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currencyPair"), processor, FieldWithMetaQuotedCurrencyPair.class, this.getCurrencyPair(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
    }

    public static class ObservableBuilderImpl
    implements ObservableBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected FieldWithMetaFloatingRateOption.FieldWithMetaFloatingRateOptionBuilder rateOption;
        protected FieldWithMetaCommodity.FieldWithMetaCommodityBuilder commodity;
        protected List<FieldWithMetaProductIdentifier.FieldWithMetaProductIdentifierBuilder> productIdentifier = new ArrayList<FieldWithMetaProductIdentifier.FieldWithMetaProductIdentifierBuilder>();
        protected FieldWithMetaQuotedCurrencyPair.FieldWithMetaQuotedCurrencyPairBuilder currencyPair;
        protected OptionReferenceTypeEnum optionReferenceType;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="rateOption")
        public FieldWithMetaFloatingRateOption.FieldWithMetaFloatingRateOptionBuilder getRateOption() {
            return this.rateOption;
        }

        @Override
        public FieldWithMetaFloatingRateOption.FieldWithMetaFloatingRateOptionBuilder getOrCreateRateOption() {
            FieldWithMetaFloatingRateOption.FieldWithMetaFloatingRateOptionBuilder result;
            if (this.rateOption != null) {
                result = this.rateOption;
            } else {
                result = this.rateOption = FieldWithMetaFloatingRateOption.builder();
                result.getOrCreateMeta().toBuilder().addKey((Key)Key.builder().setScope("DOCUMENT"));
            }
            return result;
        }

        @Override
        @RosettaAttribute(value="commodity")
        public FieldWithMetaCommodity.FieldWithMetaCommodityBuilder getCommodity() {
            return this.commodity;
        }

        @Override
        public FieldWithMetaCommodity.FieldWithMetaCommodityBuilder getOrCreateCommodity() {
            FieldWithMetaCommodity.FieldWithMetaCommodityBuilder result;
            if (this.commodity != null) {
                result = this.commodity;
            } else {
                result = this.commodity = FieldWithMetaCommodity.builder();
                result.getOrCreateMeta().toBuilder().addKey((Key)Key.builder().setScope("DOCUMENT"));
            }
            return result;
        }

        @Override
        @RosettaAttribute(value="productIdentifier")
        public List<? extends FieldWithMetaProductIdentifier.FieldWithMetaProductIdentifierBuilder> getProductIdentifier() {
            return this.productIdentifier;
        }

        @Override
        public FieldWithMetaProductIdentifier.FieldWithMetaProductIdentifierBuilder getOrCreateProductIdentifier(int _index) {
            if (this.productIdentifier == null) {
                this.productIdentifier = new ArrayList<FieldWithMetaProductIdentifier.FieldWithMetaProductIdentifierBuilder>();
            }
            return (FieldWithMetaProductIdentifier.FieldWithMetaProductIdentifierBuilder)this.getIndex(this.productIdentifier, _index, () -> {
                FieldWithMetaProductIdentifier.FieldWithMetaProductIdentifierBuilder newProductIdentifier = FieldWithMetaProductIdentifier.builder();
                newProductIdentifier.getOrCreateMeta().addKey((Key)Key.builder().setScope("DOCUMENT"));
                return newProductIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="currencyPair")
        public FieldWithMetaQuotedCurrencyPair.FieldWithMetaQuotedCurrencyPairBuilder getCurrencyPair() {
            return this.currencyPair;
        }

        @Override
        public FieldWithMetaQuotedCurrencyPair.FieldWithMetaQuotedCurrencyPairBuilder getOrCreateCurrencyPair() {
            FieldWithMetaQuotedCurrencyPair.FieldWithMetaQuotedCurrencyPairBuilder result;
            if (this.currencyPair != null) {
                result = this.currencyPair;
            } else {
                result = this.currencyPair = FieldWithMetaQuotedCurrencyPair.builder();
                result.getOrCreateMeta().toBuilder().addKey((Key)Key.builder().setScope("DOCUMENT"));
            }
            return result;
        }

        @Override
        @RosettaAttribute(value="optionReferenceType")
        public OptionReferenceTypeEnum getOptionReferenceType() {
            return this.optionReferenceType;
        }

        @Override
        @RosettaAttribute(value="meta")
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="rateOption")
        public ObservableBuilder setRateOption(FieldWithMetaFloatingRateOption rateOption) {
            this.rateOption = rateOption == null ? null : rateOption.toBuilder();
            return this;
        }

        @Override
        public ObservableBuilder setRateOptionValue(FloatingRateOption rateOption) {
            this.getOrCreateRateOption().setValue(rateOption);
            return this;
        }

        @Override
        @RosettaAttribute(value="commodity")
        public ObservableBuilder setCommodity(FieldWithMetaCommodity commodity) {
            this.commodity = commodity == null ? null : commodity.toBuilder();
            return this;
        }

        @Override
        public ObservableBuilder setCommodityValue(Commodity commodity) {
            this.getOrCreateCommodity().setValue(commodity);
            return this;
        }

        @Override
        public ObservableBuilder addProductIdentifier(FieldWithMetaProductIdentifier productIdentifier) {
            if (productIdentifier != null) {
                this.productIdentifier.add(productIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public ObservableBuilder addProductIdentifier(FieldWithMetaProductIdentifier productIdentifier, int _idx) {
            this.getIndex(this.productIdentifier, _idx, () -> productIdentifier.toBuilder());
            return this;
        }

        @Override
        public ObservableBuilder addProductIdentifierValue(ProductIdentifier productIdentifier) {
            this.getOrCreateProductIdentifier(-1).setValue(productIdentifier.toBuilder());
            return this;
        }

        @Override
        public ObservableBuilder addProductIdentifierValue(ProductIdentifier productIdentifier, int _idx) {
            this.getOrCreateProductIdentifier(_idx).setValue(productIdentifier.toBuilder());
            return this;
        }

        @Override
        public ObservableBuilder addProductIdentifier(List<? extends FieldWithMetaProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (FieldWithMetaProductIdentifier fieldWithMetaProductIdentifier : productIdentifiers) {
                    this.productIdentifier.add(fieldWithMetaProductIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="productIdentifier")
        public ObservableBuilder setProductIdentifier(List<? extends FieldWithMetaProductIdentifier> productIdentifiers) {
            this.productIdentifier = productIdentifiers == null ? new ArrayList<FieldWithMetaProductIdentifier.FieldWithMetaProductIdentifierBuilder>() : (List)productIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ObservableBuilder addProductIdentifierValue(List<? extends ProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ProductIdentifier productIdentifier : productIdentifiers) {
                    this.addProductIdentifierValue(productIdentifier);
                }
            }
            return this;
        }

        @Override
        public ObservableBuilder setProductIdentifierValue(List<? extends ProductIdentifier> productIdentifiers) {
            this.productIdentifier.clear();
            if (productIdentifiers != null) {
                productIdentifiers.forEach(this::addProductIdentifierValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyPair")
        public ObservableBuilder setCurrencyPair(FieldWithMetaQuotedCurrencyPair currencyPair) {
            this.currencyPair = currencyPair == null ? null : currencyPair.toBuilder();
            return this;
        }

        @Override
        public ObservableBuilder setCurrencyPairValue(QuotedCurrencyPair currencyPair) {
            this.getOrCreateCurrencyPair().setValue(currencyPair);
            return this;
        }

        @Override
        @RosettaAttribute(value="optionReferenceType")
        public ObservableBuilder setOptionReferenceType(OptionReferenceTypeEnum optionReferenceType) {
            this.optionReferenceType = optionReferenceType == null ? null : optionReferenceType;
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        public ObservableBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public Observable build() {
            return new ObservableImpl(this);
        }

        @Override
        public ObservableBuilder toBuilder() {
            return this;
        }

        @Override
        public ObservableBuilder prune() {
            if (this.rateOption != null && !this.rateOption.prune().hasData()) {
                this.rateOption = null;
            }
            if (this.commodity != null && !this.commodity.prune().hasData()) {
                this.commodity = null;
            }
            this.productIdentifier = this.productIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.currencyPair != null && !this.currencyPair.prune().hasData()) {
                this.currencyPair = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getRateOption() != null && this.getRateOption().hasData()) {
                return true;
            }
            if (this.getCommodity() != null && this.getCommodity().hasData()) {
                return true;
            }
            if (this.getProductIdentifier() != null && this.getProductIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCurrencyPair() != null && this.getCurrencyPair().hasData()) {
                return true;
            }
            return this.getOptionReferenceType() != null;
        }

        public ObservableBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ObservableBuilder o = (ObservableBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRateOption(), (RosettaModelObjectBuilder)o.getRateOption(), this::setRateOption);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodity(), (RosettaModelObjectBuilder)o.getCommodity(), this::setCommodity);
            merger.mergeRosetta(this.getProductIdentifier(), o.getProductIdentifier(), this::getOrCreateProductIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrencyPair(), (RosettaModelObjectBuilder)o.getCurrencyPair(), this::setCurrencyPair);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getOptionReferenceType(), (Object)o.getOptionReferenceType(), this::setOptionReferenceType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Observable _that = this.getType().cast(o);
            if (!Objects.equals(this.rateOption, _that.getRateOption())) {
                return false;
            }
            if (!Objects.equals(this.commodity, _that.getCommodity())) {
                return false;
            }
            if (!ListEquals.listEquals(this.productIdentifier, _that.getProductIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.currencyPair, _that.getCurrencyPair())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionReferenceType, (Object)_that.getOptionReferenceType())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.rateOption != null ? this.rateOption.hashCode() : 0);
            _result = 31 * _result + (this.commodity != null ? this.commodity.hashCode() : 0);
            _result = 31 * _result + (this.productIdentifier != null ? this.productIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.currencyPair != null ? this.currencyPair.hashCode() : 0);
            _result = 31 * _result + (this.optionReferenceType != null ? ((Object)((Object)this.optionReferenceType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservableBuilder {rateOption=" + this.rateOption + ", commodity=" + this.commodity + ", productIdentifier=" + this.productIdentifier + ", currencyPair=" + this.currencyPair + ", optionReferenceType=" + (Object)((Object)this.optionReferenceType) + ", meta=" + this.meta + '}';
        }
    }

    public static class ObservableImpl
    implements Observable {
        private final FieldWithMetaFloatingRateOption rateOption;
        private final FieldWithMetaCommodity commodity;
        private final List<? extends FieldWithMetaProductIdentifier> productIdentifier;
        private final FieldWithMetaQuotedCurrencyPair currencyPair;
        private final OptionReferenceTypeEnum optionReferenceType;
        private final MetaFields meta;

        protected ObservableImpl(ObservableBuilder builder) {
            this.rateOption = Optional.ofNullable(builder.getRateOption()).map(f -> f.build()).orElse(null);
            this.commodity = Optional.ofNullable(builder.getCommodity()).map(f -> f.build()).orElse(null);
            this.productIdentifier = Optional.ofNullable(builder.getProductIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.currencyPair = Optional.ofNullable(builder.getCurrencyPair()).map(f -> f.build()).orElse(null);
            this.optionReferenceType = builder.getOptionReferenceType();
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="rateOption")
        public FieldWithMetaFloatingRateOption getRateOption() {
            return this.rateOption;
        }

        @Override
        @RosettaAttribute(value="commodity")
        public FieldWithMetaCommodity getCommodity() {
            return this.commodity;
        }

        @Override
        @RosettaAttribute(value="productIdentifier")
        public List<? extends FieldWithMetaProductIdentifier> getProductIdentifier() {
            return this.productIdentifier;
        }

        @Override
        @RosettaAttribute(value="currencyPair")
        public FieldWithMetaQuotedCurrencyPair getCurrencyPair() {
            return this.currencyPair;
        }

        @Override
        @RosettaAttribute(value="optionReferenceType")
        public OptionReferenceTypeEnum getOptionReferenceType() {
            return this.optionReferenceType;
        }

        @Override
        @RosettaAttribute(value="meta")
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Observable build() {
            return this;
        }

        @Override
        public ObservableBuilder toBuilder() {
            ObservableBuilder builder = Observable.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ObservableBuilder builder) {
            Optional.ofNullable(this.getRateOption()).ifPresent(builder::setRateOption);
            Optional.ofNullable(this.getCommodity()).ifPresent(builder::setCommodity);
            Optional.ofNullable(this.getProductIdentifier()).ifPresent(builder::setProductIdentifier);
            Optional.ofNullable(this.getCurrencyPair()).ifPresent(builder::setCurrencyPair);
            Optional.ofNullable(this.getOptionReferenceType()).ifPresent(builder::setOptionReferenceType);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Observable _that = this.getType().cast(o);
            if (!Objects.equals(this.rateOption, _that.getRateOption())) {
                return false;
            }
            if (!Objects.equals(this.commodity, _that.getCommodity())) {
                return false;
            }
            if (!ListEquals.listEquals(this.productIdentifier, _that.getProductIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.currencyPair, _that.getCurrencyPair())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionReferenceType, (Object)_that.getOptionReferenceType())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.rateOption != null ? this.rateOption.hashCode() : 0);
            _result = 31 * _result + (this.commodity != null ? this.commodity.hashCode() : 0);
            _result = 31 * _result + (this.productIdentifier != null ? this.productIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.currencyPair != null ? this.currencyPair.hashCode() : 0);
            _result = 31 * _result + (this.optionReferenceType != null ? ((Object)((Object)this.optionReferenceType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Observable {rateOption=" + this.rateOption + ", commodity=" + this.commodity + ", productIdentifier=" + this.productIdentifier + ", currencyPair=" + this.currencyPair + ", optionReferenceType=" + (Object)((Object)this.optionReferenceType) + ", meta=" + this.meta + '}';
        }
    }

    public static interface ObservableBuilder
    extends Observable,
    RosettaModelObjectBuilder {
        public FieldWithMetaFloatingRateOption.FieldWithMetaFloatingRateOptionBuilder getOrCreateRateOption();

        @Override
        public FieldWithMetaFloatingRateOption.FieldWithMetaFloatingRateOptionBuilder getRateOption();

        public FieldWithMetaCommodity.FieldWithMetaCommodityBuilder getOrCreateCommodity();

        @Override
        public FieldWithMetaCommodity.FieldWithMetaCommodityBuilder getCommodity();

        public FieldWithMetaProductIdentifier.FieldWithMetaProductIdentifierBuilder getOrCreateProductIdentifier(int var1);

        public List<? extends FieldWithMetaProductIdentifier.FieldWithMetaProductIdentifierBuilder> getProductIdentifier();

        public FieldWithMetaQuotedCurrencyPair.FieldWithMetaQuotedCurrencyPairBuilder getOrCreateCurrencyPair();

        @Override
        public FieldWithMetaQuotedCurrencyPair.FieldWithMetaQuotedCurrencyPairBuilder getCurrencyPair();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public ObservableBuilder setRateOption(FieldWithMetaFloatingRateOption var1);

        public ObservableBuilder setRateOptionValue(FloatingRateOption var1);

        public ObservableBuilder setCommodity(FieldWithMetaCommodity var1);

        public ObservableBuilder setCommodityValue(Commodity var1);

        public ObservableBuilder addProductIdentifier(FieldWithMetaProductIdentifier var1);

        public ObservableBuilder addProductIdentifier(FieldWithMetaProductIdentifier var1, int var2);

        public ObservableBuilder addProductIdentifierValue(ProductIdentifier var1);

        public ObservableBuilder addProductIdentifierValue(ProductIdentifier var1, int var2);

        public ObservableBuilder addProductIdentifier(List<? extends FieldWithMetaProductIdentifier> var1);

        public ObservableBuilder setProductIdentifier(List<? extends FieldWithMetaProductIdentifier> var1);

        public ObservableBuilder addProductIdentifierValue(List<? extends ProductIdentifier> var1);

        public ObservableBuilder setProductIdentifierValue(List<? extends ProductIdentifier> var1);

        public ObservableBuilder setCurrencyPair(FieldWithMetaQuotedCurrencyPair var1);

        public ObservableBuilder setCurrencyPairValue(QuotedCurrencyPair var1);

        public ObservableBuilder setOptionReferenceType(OptionReferenceTypeEnum var1);

        public ObservableBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("optionReferenceType"), OptionReferenceTypeEnum.class, (Object)this.getOptionReferenceType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rateOption"), processor, FieldWithMetaFloatingRateOption.FieldWithMetaFloatingRateOptionBuilder.class, this.getRateOption(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodity"), processor, FieldWithMetaCommodity.FieldWithMetaCommodityBuilder.class, this.getCommodity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productIdentifier"), processor, FieldWithMetaProductIdentifier.FieldWithMetaProductIdentifierBuilder.class, this.getProductIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currencyPair"), processor, FieldWithMetaQuotedCurrencyPair.FieldWithMetaQuotedCurrencyPairBuilder.class, this.getCurrencyPair(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
        }

        public ObservableBuilder prune();
    }
}

