/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.workflow.functions;

import cdm.base.staticdata.identifier.Identifier;
import cdm.event.workflow.EventTimestamp;
import cdm.event.workflow.MessageInformation;
import cdm.event.workflow.WorkflowStep;
import cdm.event.workflow.metafields.ReferenceWithMetaWorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_RejectedWorkflowStepDefault.class)
public abstract class Create_RejectedWorkflowStep
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;

    public WorkflowStep evaluate(MessageInformation messageInformation, List<? extends EventTimestamp> timestamp, List<? extends Identifier> eventIdentifier, WorkflowStep proposedWorkflowStep) {
        WorkflowStep rejectedWorkflowStep;
        this.conditionValidator.validate(() -> ExpressionOperators.exists((Mapper)MapperS.of((Object)proposedWorkflowStep).map("getProposedEvent", workflowStep -> workflowStep.getProposedEvent())), "The previous proposed step being rejected must exist");
        WorkflowStep.WorkflowStepBuilder rejectedWorkflowStepBuilder = this.doEvaluate(messageInformation, timestamp, eventIdentifier, proposedWorkflowStep);
        if (rejectedWorkflowStepBuilder == null) {
            rejectedWorkflowStep = null;
        } else {
            rejectedWorkflowStep = rejectedWorkflowStepBuilder.build();
            this.objectValidator.validate(WorkflowStep.class, (RosettaModelObject)rejectedWorkflowStep);
        }
        return rejectedWorkflowStep;
    }

    protected abstract WorkflowStep.WorkflowStepBuilder doEvaluate(MessageInformation var1, List<? extends EventTimestamp> var2, List<? extends Identifier> var3, WorkflowStep var4);

    public static class Create_RejectedWorkflowStepDefault
    extends Create_RejectedWorkflowStep {
        @Override
        protected WorkflowStep.WorkflowStepBuilder doEvaluate(MessageInformation messageInformation, List<? extends EventTimestamp> timestamp, List<? extends Identifier> eventIdentifier, WorkflowStep proposedWorkflowStep) {
            WorkflowStep.WorkflowStepBuilder rejectedWorkflowStep = WorkflowStep.builder();
            return this.assignOutput(rejectedWorkflowStep, messageInformation, timestamp, eventIdentifier, proposedWorkflowStep);
        }

        protected WorkflowStep.WorkflowStepBuilder assignOutput(WorkflowStep.WorkflowStepBuilder rejectedWorkflowStep, MessageInformation messageInformation, List<? extends EventTimestamp> timestamp, List<? extends Identifier> eventIdentifier, WorkflowStep proposedWorkflowStep) {
            rejectedWorkflowStep.setMessageInformation((MessageInformation)MapperS.of((Object)messageInformation).get());
            rejectedWorkflowStep.addTimestamp(MapperC.of(timestamp).getMulti());
            rejectedWorkflowStep.addEventIdentifier(MapperC.of(eventIdentifier).getMulti());
            rejectedWorkflowStep.setPreviousWorkflowStep(ReferenceWithMetaWorkflowStep.builder().setGlobalReference(Optional.ofNullable((WorkflowStep)MapperS.of((Object)proposedWorkflowStep).get()).map(r -> r.getMeta()).map(m -> m.getGlobalKey()).orElse(null)).setExternalReference(Optional.ofNullable((WorkflowStep)MapperS.of((Object)proposedWorkflowStep).get()).map(r -> r.getMeta()).map(m -> m.getExternalKey()).orElse(null)).build());
            rejectedWorkflowStep.setRejected((Boolean)MapperS.of((Object)true).get());
            return Optional.ofNullable(rejectedWorkflowStep).map(o -> o.prune()).orElse(null);
        }
    }
}

