/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.position.validation.datarule;

import cdm.event.position.PortfolioState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="PortfolioStateInitialisation")
@ImplementedBy(value=Default.class)
public interface PortfolioStateInitialisation
extends Validator<PortfolioState> {
    public static final String NAME = "PortfolioStateInitialisation";
    public static final String DEFINITION = "if lineage -> portfolioStateReference is absent then positions is absent and lineage -> eventReference is absent";

    public ValidationResult<PortfolioState> validate(RosettaPath var1, PortfolioState var2);

    public static class NoOp
    implements PortfolioStateInitialisation {
        @Override
        public ValidationResult<PortfolioState> validate(RosettaPath path, PortfolioState portfolioState) {
            return ValidationResult.success((String)PortfolioStateInitialisation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PortfolioState", (RosettaPath)path, (String)PortfolioStateInitialisation.DEFINITION);
        }
    }

    public static class Default
    implements PortfolioStateInitialisation {
        @Override
        public ValidationResult<PortfolioState> validate(RosettaPath path, PortfolioState portfolioState) {
            ComparisonResult result = this.executeDataRule(portfolioState);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PortfolioStateInitialisation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PortfolioState", (RosettaPath)path, (String)PortfolioStateInitialisation.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PortfolioStateInitialisation failed.";
            }
            return ValidationResult.failure((String)PortfolioStateInitialisation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PortfolioState", (RosettaPath)path, (String)PortfolioStateInitialisation.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(PortfolioState portfolioState) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)portfolioState).map("getLineage", _portfolioState -> _portfolioState.getLineage()).mapC("getPortfolioStateReference", lineage -> lineage.getPortfolioStateReference()).map("getValue", _f -> _f.getValue())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.notExists((Mapper)MapperS.of((Object)portfolioState).mapC("getPositions", _portfolioState -> _portfolioState.getPositions())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)portfolioState).map("getLineage", _portfolioState -> _portfolioState.getLineage()).mapC("getEventReference", lineage -> lineage.getEventReference()).map("getValue", _f -> _f.getValue())));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

