/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.Instruction;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="InstructionNewTrade")
@ImplementedBy(value=Default.class)
public interface InstructionNewTrade
extends Validator<Instruction> {
    public static final String NAME = "InstructionNewTrade";
    public static final String DEFINITION = "(if primitiveInstruction -> execution exists then before is absent) and (if before is absent then primitiveInstruction -> execution exists)";

    public ValidationResult<Instruction> validate(RosettaPath var1, Instruction var2);

    public static class NoOp
    implements InstructionNewTrade {
        @Override
        public ValidationResult<Instruction> validate(RosettaPath path, Instruction instruction) {
            return ValidationResult.success((String)InstructionNewTrade.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Instruction", (RosettaPath)path, (String)InstructionNewTrade.DEFINITION);
        }
    }

    public static class Default
    implements InstructionNewTrade {
        @Override
        public ValidationResult<Instruction> validate(RosettaPath path, Instruction instruction) {
            ComparisonResult result = this.executeDataRule(instruction);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)InstructionNewTrade.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Instruction", (RosettaPath)path, (String)InstructionNewTrade.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition InstructionNewTrade failed.";
            }
            return ValidationResult.failure((String)InstructionNewTrade.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Instruction", (RosettaPath)path, (String)InstructionNewTrade.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Instruction instruction) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)instruction).map("getPrimitiveInstruction", _instruction -> _instruction.getPrimitiveInstruction()).map("getExecution", primitiveInstruction -> primitiveInstruction.getExecution())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.notExists((Mapper)MapperS.of((Object)instruction).map("getBefore", _instruction -> _instruction.getBefore()).map("getValue", _f -> _f.getValue()));
                    }
                    return null;
                })).and(MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)instruction).map("getBefore", _instruction -> _instruction.getBefore()).map("getValue", _f -> _f.getValue())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)instruction).map("getPrimitiveInstruction", _instruction -> _instruction.getPrimitiveInstruction()).map("getExecution", primitiveInstruction -> primitiveInstruction.getExecution()));
                    }
                    return null;
                })));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

