/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.QuantitySchedule;
import cdm.base.math.functions.FilterQuantityByFinancialUnit;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.event.common.Reset;
import cdm.event.common.TradeState;
import cdm.event.common.Transfer;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.functions.FixedAmount;
import cdm.product.asset.functions.FloatingAmount;
import cdm.product.collateral.Collateral;
import cdm.product.collateral.EligibleCollateralCriteria;
import cdm.product.common.schedule.CalculationPeriodData;
import cdm.product.common.schedule.functions.CalculationPeriodRange;
import cdm.product.template.AssetPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ResolveSecurityFinanceBillingAmountDefault.class)
public abstract class ResolveSecurityFinanceBillingAmount
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CalculationPeriodRange calculationPeriodRange0;
    @Inject
    protected ExtractCounterpartyByRole extractCounterpartyByRole;
    @Inject
    protected FilterQuantityByFinancialUnit filterQuantityByFinancialUnit;
    @Inject
    protected FixedAmount fixedAmount;
    @Inject
    protected FloatingAmount floatingAmount;

    public Transfer evaluate(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
        Transfer transfer;
        Transfer.TransferBuilder transferBuilder = this.doEvaluate(tradeState, reset, recordStartDate, recordEndDate, transferDate);
        if (transferBuilder == null) {
            transfer = null;
        } else {
            transfer = transferBuilder.build();
            this.objectValidator.validate(Transfer.class, (RosettaModelObject)transfer);
        }
        return transfer;
    }

    protected abstract Transfer.TransferBuilder doEvaluate(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract Mapper<? extends QuantitySchedule> securityQuantity(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract Mapper<? extends InterestRatePayout> interestRatePayout(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract Mapper<? extends AssetPayout> assetPayout(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract Mapper<? extends Collateral> collateral(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract Mapper<BigDecimal> haircutPercentage(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract Mapper<BigDecimal> valuationPercentage(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract Mapper<BigDecimal> marginRatio(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract Mapper<BigDecimal> billingQuantity(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract Mapper<? extends CalculationPeriodData> calculationPeriodRange1(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract Mapper<BigDecimal> performance(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract Mapper<? extends Party> payerPartyReference(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    protected abstract Mapper<? extends Party> receiverPartyReference(TradeState var1, Reset var2, Date var3, Date var4, Date var5);

    public static class ResolveSecurityFinanceBillingAmountDefault
    extends ResolveSecurityFinanceBillingAmount {
        @Override
        protected Transfer.TransferBuilder doEvaluate(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            Transfer.TransferBuilder transfer = Transfer.builder();
            return this.assignOutput(transfer, tradeState, reset, recordStartDate, recordEndDate, transferDate);
        }

        protected Transfer.TransferBuilder assignOutput(Transfer.TransferBuilder transfer, TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            transfer.getOrCreateQuantity().setValue((BigDecimal)MapperS.of((Object)((BigDecimal)this.performance(tradeState, reset, recordStartDate, recordEndDate, transferDate).get())).get());
            transfer.getOrCreateQuantity().getOrCreateUnit().setCurrencyValue((String)MapperS.of((Object)((InterestRatePayout)this.interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).get())).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("getValue", _f -> _f.getValue()).map("getUnit", measureBase -> measureBase.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("getValue", _f -> _f.getValue()).get());
            transfer.getOrCreatePayerReceiver().setPayerPartyReferenceValue((Party)MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)((BigDecimal)this.performance(tradeState, reset, recordStartDate, recordEndDate, transferDate).get())), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Party)this.payerPartyReference(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()));
                }
                return MapperS.of((Object)((Party)this.receiverPartyReference(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()));
            }).get());
            transfer.getOrCreatePayerReceiver().setReceiverPartyReferenceValue((Party)MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)((BigDecimal)this.performance(tradeState, reset, recordStartDate, recordEndDate, transferDate).get())), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Party)this.receiverPartyReference(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()));
                }
                return MapperS.of((Object)((Party)this.payerPartyReference(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()));
            }).get());
            transfer.getOrCreateSettlementDate().setAdjustedDateValue((Date)MapperS.of((Object)transferDate).get());
            return Optional.ofNullable(transfer).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<? extends QuantitySchedule> securityQuantity(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperC.of(this.filterQuantityByFinancialUnit.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("getValue", _f -> _f.getValue()).getMulti(), (FinancialUnitEnum)((Object)MapperS.of((Object)((Object)FinancialUnitEnum.SHARE)).get())));
        }

        @Override
        protected Mapper<? extends InterestRatePayout> interestRatePayout(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperS.of((Object)((InterestRatePayout)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get()));
        }

        @Override
        protected Mapper<? extends AssetPayout> assetPayout(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperS.of((Object)((AssetPayout)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getCollateral", economicTerms -> economicTerms.getCollateral()).mapC("getCollateralPortfolio", _collateral -> _collateral.getCollateralPortfolio()).map("getValue", _f -> _f.getValue()).mapC("getCollateralPosition", collateralPortfolio -> collateralPortfolio.getCollateralPosition()).map("getProduct", position -> position.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getAssetPayout", payout -> payout.getAssetPayout()).get()));
        }

        @Override
        protected Mapper<? extends Collateral> collateral(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getCollateral", economicTerms -> economicTerms.getCollateral());
        }

        @Override
        protected Mapper<BigDecimal> haircutPercentage(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperMaths.subtract((Mapper)MapperS.of((Object)new BigDecimal("1.0")), (Mapper)MapperS.of((Object)((EligibleCollateralCriteria)MapperS.of((Object)((Collateral)this.collateral(tradeState, reset, recordStartDate, recordEndDate, transferDate).get())).map("getCollateralProvisions", _collateral -> _collateral.getCollateralProvisions()).mapC("getEligibleCollateral", collateralProvisions -> collateralProvisions.getEligibleCollateral()).get())).map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).map("getValuationTreatment", collateralTreatment -> collateralTreatment.getValuationTreatment()).map("getHaircutPercentage", collateralValuationTreatment -> collateralValuationTreatment.getHaircutPercentage()));
        }

        @Override
        protected Mapper<BigDecimal> valuationPercentage(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperMaths.divide((Mapper)MapperS.of((Object)1), (Mapper)MapperS.of((Object)((BigDecimal)this.haircutPercentage(tradeState, reset, recordStartDate, recordEndDate, transferDate).get())));
        }

        @Override
        protected Mapper<BigDecimal> marginRatio(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((EligibleCollateralCriteria)MapperS.of((Object)((Collateral)this.collateral(tradeState, reset, recordStartDate, recordEndDate, transferDate).get())).map("getCollateralProvisions", _collateral -> _collateral.getCollateralProvisions()).mapC("getEligibleCollateral", collateralProvisions -> collateralProvisions.getEligibleCollateral()).get())).map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).map("getValuationTreatment", collateralTreatment -> collateralTreatment.getValuationTreatment()).map("getHaircutPercentage", collateralValuationTreatment -> collateralValuationTreatment.getHaircutPercentage())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((BigDecimal)this.valuationPercentage(tradeState, reset, recordStartDate, recordEndDate, transferDate).get()));
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((EligibleCollateralCriteria)MapperS.of((Object)((Collateral)this.collateral(tradeState, reset, recordStartDate, recordEndDate, transferDate).get())).map("getCollateralProvisions", _collateral -> _collateral.getCollateralProvisions()).mapC("getEligibleCollateral", collateralProvisions -> collateralProvisions.getEligibleCollateral()).get())).map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).map("getValuationTreatment", collateralTreatment -> collateralTreatment.getValuationTreatment()).map("getMarginPercentage", collateralValuationTreatment -> collateralValuationTreatment.getMarginPercentage())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((EligibleCollateralCriteria)MapperS.of((Object)((Collateral)this.collateral(tradeState, reset, recordStartDate, recordEndDate, transferDate).get())).map("getCollateralProvisions", _collateral -> _collateral.getCollateralProvisions()).mapC("getEligibleCollateral", collateralProvisions -> collateralProvisions.getEligibleCollateral()).get())).map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).map("getValuationTreatment", collateralTreatment -> collateralTreatment.getValuationTreatment()).map("getMarginPercentage", collateralValuationTreatment -> collateralValuationTreatment.getMarginPercentage());
                }
                return MapperS.of((Object)new BigDecimal("1.0"));
            });
        }

        @Override
        protected Mapper<BigDecimal> billingQuantity(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperMaths.multiply((Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)reset).map("getResetValue", _reset -> _reset.getResetValue()).map("getValue", measureBase -> measureBase.getValue()), (Mapper)MapperC.of((List)this.securityQuantity(tradeState, reset, recordStartDate, recordEndDate, transferDate).getMulti()).map("getValue", measureBase -> measureBase.getValue())), (Mapper)MapperS.of((Object)((BigDecimal)this.marginRatio(tradeState, reset, recordStartDate, recordEndDate, transferDate).get())));
        }

        @Override
        protected Mapper<? extends CalculationPeriodData> calculationPeriodRange1(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperS.of((Object)this.calculationPeriodRange0.evaluate((Date)MapperS.of((Object)recordStartDate).get(), (Date)MapperS.of((Object)recordEndDate).get(), null));
        }

        @Override
        protected Mapper<BigDecimal> performance(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((InterestRatePayout)this.interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).get())).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.fixedAmount.evaluate((InterestRatePayout)MapperS.of((Object)((InterestRatePayout)this.interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).get())).get(), (BigDecimal)MapperS.of((Object)((BigDecimal)this.billingQuantity(tradeState, reset, recordStartDate, recordEndDate, transferDate).get())).get(), (Date)MapperS.of((Object)recordEndDate).get(), (CalculationPeriodData)MapperS.of((Object)((CalculationPeriodData)this.calculationPeriodRange1(tradeState, reset, recordStartDate, recordEndDate, transferDate).get())).get()));
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((InterestRatePayout)this.interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).get())).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.floatingAmount.evaluate((InterestRatePayout)MapperS.of((Object)((InterestRatePayout)this.interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).get())).get(), (BigDecimal)MapperS.of((Object)reset).map("getResetValue", _reset -> _reset.getResetValue()).map("getValue", measureBase -> measureBase.getValue()).get(), (BigDecimal)MapperS.of((Object)((BigDecimal)this.billingQuantity(tradeState, reset, recordStartDate, recordEndDate, transferDate).get())).get(), (Date)MapperS.of((Object)recordEndDate).get(), (CalculationPeriodData)MapperS.of((Object)((CalculationPeriodData)this.calculationPeriodRange1(tradeState, reset, recordStartDate, recordEndDate, transferDate).get())).get()));
                }
                return MapperS.ofNull();
            });
        }

        @Override
        protected Mapper<? extends Party> payerPartyReference(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)MapperS.of((Object)((InterestRatePayout)this.interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).get())).map("getPayerReceiver", payoutBase -> payoutBase.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).map("getValue", _f -> _f.getValue());
        }

        @Override
        protected Mapper<? extends Party> receiverPartyReference(TradeState tradeState, Reset reset, Date recordStartDate, Date recordEndDate, Date transferDate) {
            return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)MapperS.of((Object)((InterestRatePayout)this.interestRatePayout(tradeState, reset, recordStartDate, recordEndDate, transferDate).get())).map("getPayerReceiver", payoutBase -> payoutBase.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).map("getValue", _f -> _f.getValue());
        }
    }
}

