/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.datetime.BusinessCenterTime;
import cdm.base.datetime.TimeZone;
import cdm.base.datetime.functions.ResolveAdjustableDate;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.event.common.functions.AdjustedValuationDates;
import cdm.event.common.functions.ResolvePerformanceValuationTime;
import cdm.observable.asset.PerformanceValuationDates;
import cdm.observable.asset.ValuationDates;
import cdm.observable.common.DeterminationMethodEnum;
import cdm.observable.common.TimeTypeEnum;
import cdm.observable.event.ObservationIdentifier;
import cdm.product.template.PerformancePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ResolvePerformanceObservationIdentifiersDefault.class)
public abstract class ResolvePerformanceObservationIdentifiers
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected AdjustedValuationDates adjustedValuationDates;
    @Inject
    protected ResolveAdjustableDate resolveAdjustableDate;
    @Inject
    protected ResolvePerformanceValuationTime resolvePerformanceValuationTime;

    public ObservationIdentifier evaluate(PerformancePayout payout, Date adjustedDate) {
        ObservationIdentifier identifiers;
        ObservationIdentifier.ObservationIdentifierBuilder identifiersBuilder = this.doEvaluate(payout, adjustedDate);
        if (identifiersBuilder == null) {
            identifiers = null;
        } else {
            identifiers = identifiersBuilder.build();
            this.objectValidator.validate(ObservationIdentifier.class, (RosettaModelObject)identifiers);
        }
        return identifiers;
    }

    protected abstract ObservationIdentifier.ObservationIdentifierBuilder doEvaluate(PerformancePayout var1, Date var2);

    protected abstract Mapper<Date> adjustedFinalValuationDate(PerformancePayout var1, Date var2);

    protected abstract Mapper<? extends PerformanceValuationDates> valuationDates(PerformancePayout var1, Date var2);

    public static class ResolvePerformanceObservationIdentifiersDefault
    extends ResolvePerformanceObservationIdentifiers {
        @Override
        protected ObservationIdentifier.ObservationIdentifierBuilder doEvaluate(PerformancePayout payout, Date adjustedDate) {
            ObservationIdentifier.ObservationIdentifierBuilder identifiers = ObservationIdentifier.builder();
            return this.assignOutput(identifiers, payout, adjustedDate);
        }

        protected ObservationIdentifier.ObservationIdentifierBuilder assignOutput(ObservationIdentifier.ObservationIdentifierBuilder identifiers, PerformancePayout payout, Date adjustedDate) {
            identifiers.getOrCreateObservable().addProductIdentifierValue(MapperS.of((Object)payout).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getSecurity", product -> product.getSecurity()).mapC("getProductIdentifier", productBase -> productBase.getProductIdentifier()).map("getValue", _f -> _f.getValue()).getMulti());
            identifiers.setObservationDate((Date)((MapperS)MapperC.of(this.adjustedValuationDates.evaluate((ValuationDates)MapperS.of((Object)payout).map("getValuationDates", performancePayout -> performancePayout.getValuationDates()).get())).filterItemNullSafe(item -> ExpressionOperators.lessThanEquals((Mapper)item, (Mapper)MapperS.of((Object)adjustedDate), (CardinalityOperator)CardinalityOperator.All).get()).apply(item -> item.last())).get());
            identifiers.setObservationTime((TimeZone)MapperS.of((Object)this.resolvePerformanceValuationTime.evaluate((BusinessCenterTime)MapperS.of((Object)((PerformanceValuationDates)this.valuationDates(payout, adjustedDate).get())).map("getValuationTime", performanceValuationDates -> performanceValuationDates.getValuationTime()).get(), (TimeTypeEnum)((Object)MapperS.of((Object)((PerformanceValuationDates)this.valuationDates(payout, adjustedDate).get())).map("getValuationTimeType", performanceValuationDates -> performanceValuationDates.getValuationTimeType()).get()), (ProductIdentifier)MapperS.of((Object)((ProductIdentifier)MapperS.of((Object)identifiers).map("getObservable", observationIdentifier -> observationIdentifier.getObservable()).mapC("getProductIdentifier", observable -> observable.getProductIdentifier()).map("getValue", _f -> _f.getValue()).get())).get(), (DeterminationMethodEnum)((Object)MapperS.of((Object)((PerformanceValuationDates)this.valuationDates(payout, adjustedDate).get())).map("getDeterminationMethod", performanceValuationDates -> performanceValuationDates.getDeterminationMethod()).get()))).get());
            identifiers.getOrCreateDeterminationMethodology().setDeterminationMethod((DeterminationMethodEnum)((Object)MapperS.of((Object)((PerformanceValuationDates)this.valuationDates(payout, adjustedDate).get())).map("getDeterminationMethod", performanceValuationDates -> performanceValuationDates.getDeterminationMethod()).get()));
            return Optional.ofNullable(identifiers).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<Date> adjustedFinalValuationDate(PerformancePayout payout, Date adjustedDate) {
            return MapperS.of((Object)this.resolveAdjustableDate.evaluate((AdjustableOrRelativeDate)MapperS.of((Object)payout).map("getValuationDates", performancePayout -> performancePayout.getValuationDates()).map("getValuationDatesFinal", _valuationDates -> _valuationDates.getValuationDatesFinal()).map("getValuationDate", performanceValuationDates -> performanceValuationDates.getValuationDate()).get()));
        }

        @Override
        protected Mapper<? extends PerformanceValuationDates> valuationDates(PerformancePayout payout, Date adjustedDate) {
            return MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.lessThan((Mapper)MapperS.of((Object)adjustedDate), (Mapper)MapperS.of((Object)((Date)this.adjustedFinalValuationDate(payout, adjustedDate).get())), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)payout).map("getValuationDates", performancePayout -> performancePayout.getValuationDates()).map("getValuationDatesInterim", _valuationDates -> _valuationDates.getValuationDatesInterim());
                }
                return MapperS.of((Object)payout).map("getValuationDates", performancePayout -> performancePayout.getValuationDates()).map("getValuationDatesFinal", _valuationDates -> _valuationDates.getValuationDatesFinal());
            });
        }
    }
}

