/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.BusinessEvent;
import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import cdm.event.common.functions.ExtractAfterTradableProduct;
import cdm.event.common.functions.ExtractBeforeEconomicTerms;
import cdm.event.common.functions.ExtractBeforeTradableProduct;
import cdm.event.common.functions.ExtractOpenEconomicTerms;
import cdm.event.common.functions.ExtractTradeCollateralPrice;
import cdm.event.common.functions.ExtractTradeCollateralQuantity;
import cdm.event.common.functions.ExtractTradePurchasePrice;
import cdm.event.common.functions.FilterClosedTradeStates;
import cdm.event.common.functions.FilterOpenTradeStates;
import cdm.product.template.EconomicTerms;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.IQualifyFunctionExtension;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=Qualify_RepriceDefault.class)
public abstract class Qualify_Reprice
implements RosettaFunction,
IQualifyFunctionExtension<BusinessEvent> {
    @Inject
    protected ExtractAfterTradableProduct extractAfterTradableProduct;
    @Inject
    protected ExtractBeforeEconomicTerms extractBeforeEconomicTerms;
    @Inject
    protected ExtractBeforeTradableProduct extractBeforeTradableProduct;
    @Inject
    protected ExtractOpenEconomicTerms extractOpenEconomicTerms;
    @Inject
    protected ExtractTradeCollateralPrice extractTradeCollateralPrice;
    @Inject
    protected ExtractTradeCollateralQuantity extractTradeCollateralQuantity;
    @Inject
    protected ExtractTradePurchasePrice extractTradePurchasePrice;
    @Inject
    protected FilterClosedTradeStates filterClosedTradeStates;
    @Inject
    protected FilterOpenTradeStates filterOpenTradeStates;

    public Boolean evaluate(BusinessEvent businessEvent) {
        Boolean is_event = this.doEvaluate(businessEvent);
        return is_event;
    }

    protected abstract Boolean doEvaluate(BusinessEvent var1);

    protected abstract Mapper<? extends Trade> openTrades(BusinessEvent var1);

    protected abstract Mapper<? extends TradeState> closedTradeState(BusinessEvent var1);

    protected abstract Mapper<? extends TradableProduct> beforeTradableProduct(BusinessEvent var1);

    protected abstract Mapper<? extends TradableProduct> afterTradableProduct(BusinessEvent var1);

    protected abstract Mapper<BigDecimal> beforeTradePurchasePrice(BusinessEvent var1);

    protected abstract Mapper<BigDecimal> afterTradePurchasePrice(BusinessEvent var1);

    protected abstract Mapper<BigDecimal> beforeTradeCollateralQuantity(BusinessEvent var1);

    protected abstract Mapper<BigDecimal> afterTradeCollateralQuantity(BusinessEvent var1);

    protected abstract Mapper<BigDecimal> beforeTradeCollateralPrice(BusinessEvent var1);

    protected abstract Mapper<BigDecimal> afterTradeCollateralPrice(BusinessEvent var1);

    protected abstract Mapper<? extends EconomicTerms> beforeEconomicterms(BusinessEvent var1);

    protected abstract Mapper<? extends EconomicTerms> openEconomicTerms(BusinessEvent var1);

    public String getNamePrefix() {
        return "Qualify";
    }

    public static class Qualify_RepriceDefault
    extends Qualify_Reprice {
        @Override
        protected Boolean doEvaluate(BusinessEvent businessEvent) {
            Boolean is_event = null;
            return this.assignOutput(is_event, businessEvent);
        }

        protected Boolean assignOutput(Boolean is_event, BusinessEvent businessEvent) {
            is_event = ExpressionOperators.exists((Mapper)MapperS.of((Object)businessEvent).mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout())).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)MapperC.of((List)this.openTrades(businessEvent).getMulti()).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)MapperC.of((List)this.closedTradeState(businessEvent).getMulti()).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.exists((Mapper)MapperC.of((List)this.beforeTradePurchasePrice(businessEvent).getMulti()))).and(ExpressionOperators.exists((Mapper)MapperC.of((List)this.afterTradePurchasePrice(businessEvent).getMulti()))).and(ExpressionOperators.notEqual((Mapper)MapperC.of((List)this.afterTradePurchasePrice(businessEvent).getMulti()), (Mapper)MapperC.of((List)this.beforeTradePurchasePrice(businessEvent).getMulti()), (CardinalityOperator)CardinalityOperator.Any)).and(ExpressionOperators.areEqual((Mapper)MapperC.of((List)this.beforeTradeCollateralQuantity(businessEvent).getMulti()), (Mapper)MapperC.of((List)this.afterTradeCollateralQuantity(businessEvent).getMulti()), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.notEqual((Mapper)MapperC.of((List)this.beforeTradeCollateralPrice(businessEvent).getMulti()), (Mapper)MapperC.of((List)this.afterTradeCollateralPrice(businessEvent).getMulti()), (CardinalityOperator)CardinalityOperator.Any)).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)((EconomicTerms)this.beforeEconomicterms(businessEvent).get())))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)((EconomicTerms)this.openEconomicTerms(businessEvent).get())))).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((EconomicTerms)this.openEconomicTerms(businessEvent).get())).map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()), (Mapper)MapperS.of((Object)((EconomicTerms)this.beforeEconomicterms(businessEvent).get())).map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()), (CardinalityOperator)CardinalityOperator.All)).get();
            return is_event;
        }

        @Override
        protected Mapper<? extends Trade> openTrades(BusinessEvent businessEvent) {
            return MapperC.of(this.filterOpenTradeStates.evaluate(MapperS.of((Object)businessEvent).mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).getMulti())).map("getTrade", tradeState -> tradeState.getTrade());
        }

        @Override
        protected Mapper<? extends TradeState> closedTradeState(BusinessEvent businessEvent) {
            return MapperC.of(this.filterClosedTradeStates.evaluate(MapperS.of((Object)businessEvent).mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).getMulti()));
        }

        @Override
        protected Mapper<? extends TradableProduct> beforeTradableProduct(BusinessEvent businessEvent) {
            return MapperS.of((Object)this.extractBeforeTradableProduct.evaluate((BusinessEvent)MapperS.of((Object)businessEvent).get()));
        }

        @Override
        protected Mapper<? extends TradableProduct> afterTradableProduct(BusinessEvent businessEvent) {
            return MapperS.of((Object)this.extractAfterTradableProduct.evaluate((BusinessEvent)MapperS.of((Object)businessEvent).get()));
        }

        @Override
        protected Mapper<BigDecimal> beforeTradePurchasePrice(BusinessEvent businessEvent) {
            return MapperC.of(this.extractTradePurchasePrice.evaluate((TradableProduct)MapperS.of((Object)((TradableProduct)this.beforeTradableProduct(businessEvent).get())).get()));
        }

        @Override
        protected Mapper<BigDecimal> afterTradePurchasePrice(BusinessEvent businessEvent) {
            return MapperC.of(this.extractTradePurchasePrice.evaluate((TradableProduct)MapperS.of((Object)((TradableProduct)this.afterTradableProduct(businessEvent).get())).get()));
        }

        @Override
        protected Mapper<BigDecimal> beforeTradeCollateralQuantity(BusinessEvent businessEvent) {
            return MapperC.of(this.extractTradeCollateralQuantity.evaluate((TradableProduct)MapperS.of((Object)((TradableProduct)this.beforeTradableProduct(businessEvent).get())).get()));
        }

        @Override
        protected Mapper<BigDecimal> afterTradeCollateralQuantity(BusinessEvent businessEvent) {
            return MapperC.of(this.extractTradeCollateralQuantity.evaluate((TradableProduct)MapperS.of((Object)((TradableProduct)this.afterTradableProduct(businessEvent).get())).get()));
        }

        @Override
        protected Mapper<BigDecimal> beforeTradeCollateralPrice(BusinessEvent businessEvent) {
            return MapperC.of(this.extractTradeCollateralPrice.evaluate((TradableProduct)MapperS.of((Object)((TradableProduct)this.beforeTradableProduct(businessEvent).get())).get()));
        }

        @Override
        protected Mapper<BigDecimal> afterTradeCollateralPrice(BusinessEvent businessEvent) {
            return MapperC.of(this.extractTradeCollateralPrice.evaluate((TradableProduct)MapperS.of((Object)((TradableProduct)this.afterTradableProduct(businessEvent).get())).get()));
        }

        @Override
        protected Mapper<? extends EconomicTerms> beforeEconomicterms(BusinessEvent businessEvent) {
            return MapperS.of((Object)this.extractBeforeEconomicTerms.evaluate((BusinessEvent)MapperS.of((Object)businessEvent).get()));
        }

        @Override
        protected Mapper<? extends EconomicTerms> openEconomicTerms(BusinessEvent businessEvent) {
            return MapperS.of((Object)this.extractOpenEconomicTerms.evaluate((BusinessEvent)MapperS.of((Object)businessEvent).get()));
        }
    }
}

