/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.BusinessEvent;
import cdm.event.common.TradeState;
import cdm.event.common.functions.FilterOpenTradeStates;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ExtractAfterTradableProductDefault.class)
public abstract class ExtractAfterTradableProduct
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected FilterOpenTradeStates filterOpenTradeStates;

    public TradableProduct evaluate(BusinessEvent businessEvent) {
        TradableProduct tradableProduct;
        TradableProduct.TradableProductBuilder tradableProductBuilder = this.doEvaluate(businessEvent);
        if (tradableProductBuilder == null) {
            tradableProduct = null;
        } else {
            tradableProduct = tradableProductBuilder.build();
            this.objectValidator.validate(TradableProduct.class, (RosettaModelObject)tradableProduct);
        }
        return tradableProduct;
    }

    protected abstract TradableProduct.TradableProductBuilder doEvaluate(BusinessEvent var1);

    public static class ExtractAfterTradableProductDefault
    extends ExtractAfterTradableProduct {
        @Override
        protected TradableProduct.TradableProductBuilder doEvaluate(BusinessEvent businessEvent) {
            TradableProduct.TradableProductBuilder tradableProduct = TradableProduct.builder();
            return this.assignOutput(tradableProduct, businessEvent);
        }

        protected TradableProduct.TradableProductBuilder assignOutput(TradableProduct.TradableProductBuilder tradableProduct, BusinessEvent businessEvent) {
            tradableProduct = (TradableProduct.TradableProductBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((TradeState)MapperC.of(this.filterOpenTradeStates.evaluate(MapperS.of((Object)businessEvent).mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).getMulti())).get())).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).get());
            return Optional.ofNullable(tradableProduct).map(o -> o.prune()).orElse(null);
        }
    }
}

