/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.NonNegativeQuantity;
import cdm.base.math.Quantity;
import cdm.base.math.QuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.functions.FilterQuantityByFinancialUnit;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.event.common.CalculateTransferInstruction;
import cdm.event.common.Transfer;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.functions.FilterPrice;
import cdm.product.template.AssetPayout;
import cdm.product.template.metafields.ReferenceWithMetaAssetPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_AssetTransferDefault.class)
public abstract class Create_AssetTransfer
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ExtractCounterpartyByRole extractCounterpartyByRole;
    @Inject
    protected FilterPrice filterPrice;
    @Inject
    protected FilterQuantityByFinancialUnit filterQuantityByFinancialUnit;

    public Transfer evaluate(CalculateTransferInstruction instruction) {
        Transfer transfer;
        this.conditionValidator.validate(() -> MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)instruction).map("getQuantity", calculateTransferInstruction -> calculateTransferInstruction.getQuantity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)instruction).map("getQuantity", calculateTransferInstruction -> calculateTransferInstruction.getQuantity()).map("getUnit", measureBase -> measureBase.getUnit()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit()), (Mapper)MapperS.of((Object)((Object)FinancialUnitEnum.SHARE)), (CardinalityOperator)CardinalityOperator.All);
            }
            return null;
        })), "");
        Transfer.TransferBuilder transferBuilder = this.doEvaluate(instruction);
        if (transferBuilder == null) {
            transfer = null;
        } else {
            transfer = transferBuilder.build();
            this.objectValidator.validate(Transfer.class, (RosettaModelObject)transfer);
        }
        return transfer;
    }

    protected abstract Transfer.TransferBuilder doEvaluate(CalculateTransferInstruction var1);

    protected abstract Mapper<? extends AssetPayout> assetPayout(CalculateTransferInstruction var1);

    protected abstract Mapper<? extends QuantitySchedule> tradeQuantity(CalculateTransferInstruction var1);

    protected abstract Mapper<? extends Quantity> securityQuantity(CalculateTransferInstruction var1);

    protected abstract Mapper<? extends PriceSchedule> securityPrice(CalculateTransferInstruction var1);

    public static class Create_AssetTransferDefault
    extends Create_AssetTransfer {
        @Override
        protected Transfer.TransferBuilder doEvaluate(CalculateTransferInstruction instruction) {
            Transfer.TransferBuilder transfer = Transfer.builder();
            return this.assignOutput(transfer, instruction);
        }

        protected Transfer.TransferBuilder assignOutput(Transfer.TransferBuilder transfer, CalculateTransferInstruction instruction) {
            transfer.setQuantity((NonNegativeQuantity)MapperS.of((Object)NonNegativeQuantity.builder().setValue((BigDecimal)MapperS.of((Object)((Quantity)this.securityQuantity(instruction).get())).map("getValue", measureBase -> measureBase.getValue()).get()).setUnit((UnitType)MapperS.of((Object)((Quantity)this.securityQuantity(instruction).get())).map("getUnit", measureBase -> measureBase.getUnit()).get()).build()).get());
            transfer.getOrCreateObservable().addProductIdentifierValue(MapperS.of((Object)((AssetPayout)this.assetPayout(instruction).get())).map("getSecurityInformation", _assetPayout -> _assetPayout.getSecurityInformation()).map("getSecurity", product -> product.getSecurity()).mapC("getProductIdentifier", productBase -> productBase.getProductIdentifier()).map("getValue", _f -> _f.getValue()).getMulti());
            transfer.getOrCreatePayerReceiver().setPayerPartyReferenceValue((Party)MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)instruction).map("getPayerReceiver", calculateTransferInstruction -> calculateTransferInstruction.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)((Object)MapperS.of((Object)instruction).map("getPayerReceiver", calculateTransferInstruction -> calculateTransferInstruction.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer()).get())))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).map("getValue", _f -> _f.getValue());
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((AssetPayout)this.assetPayout(instruction).get())).map("getPayerReceiver", payoutBase -> payoutBase.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)((Object)MapperS.of((Object)((AssetPayout)this.assetPayout(instruction).get())).map("getPayerReceiver", payoutBase -> payoutBase.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer()).get())))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).map("getValue", _f -> _f.getValue());
                }
                return MapperS.ofNull();
            }).get());
            transfer.getOrCreatePayerReceiver().setReceiverPartyReferenceValue((Party)MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)instruction).map("getPayerReceiver", calculateTransferInstruction -> calculateTransferInstruction.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)((Object)MapperS.of((Object)instruction).map("getPayerReceiver", calculateTransferInstruction -> calculateTransferInstruction.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get())))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).map("getValue", _f -> _f.getValue());
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((AssetPayout)this.assetPayout(instruction).get())).map("getPayerReceiver", payoutBase -> payoutBase.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)((Object)MapperS.of((Object)((AssetPayout)this.assetPayout(instruction).get())).map("getPayerReceiver", payoutBase -> payoutBase.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get())))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).map("getValue", _f -> _f.getValue());
                }
                return MapperS.ofNull();
            }).get());
            transfer.getOrCreateSettlementDate().setAdjustedDateValue((Date)MapperS.of((Object)instruction).map("getDate", calculateTransferInstruction -> calculateTransferInstruction.getDate()).get());
            transfer.getOrCreateSettlementOrigin().setAssetPayout(ReferenceWithMetaAssetPayout.builder().setGlobalReference(Optional.ofNullable((AssetPayout)MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getCollateral", economicTerms -> economicTerms.getCollateral()).mapC("getCollateralPortfolio", collateral -> collateral.getCollateralPortfolio()).map("getValue", _f -> _f.getValue()).mapC("getCollateralPosition", collateralPortfolio -> collateralPortfolio.getCollateralPosition()).map("getProduct", position -> position.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getAssetPayout", payout -> payout.getAssetPayout())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((AssetPayout)MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getCollateral", economicTerms -> economicTerms.getCollateral()).mapC("getCollateralPortfolio", collateral -> collateral.getCollateralPortfolio()).map("getValue", _f -> _f.getValue()).mapC("getCollateralPosition", collateralPortfolio -> collateralPortfolio.getCollateralPosition()).map("getProduct", position -> position.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getAssetPayout", payout -> payout.getAssetPayout()).get()));
                }
                return null;
            }).get()).map(r -> r.getMeta()).map(m -> m.getGlobalKey()).orElse(null)).setExternalReference(Optional.ofNullable((AssetPayout)MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getCollateral", economicTerms -> economicTerms.getCollateral()).mapC("getCollateralPortfolio", collateral -> collateral.getCollateralPortfolio()).map("getValue", _f -> _f.getValue()).mapC("getCollateralPosition", collateralPortfolio -> collateralPortfolio.getCollateralPosition()).map("getProduct", position -> position.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getAssetPayout", payout -> payout.getAssetPayout())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((AssetPayout)MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getCollateral", economicTerms -> economicTerms.getCollateral()).mapC("getCollateralPortfolio", collateral -> collateral.getCollateralPortfolio()).map("getValue", _f -> _f.getValue()).mapC("getCollateralPosition", collateralPortfolio -> collateralPortfolio.getCollateralPosition()).map("getProduct", position -> position.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getAssetPayout", payout -> payout.getAssetPayout()).get()));
                }
                return null;
            }).get()).map(r -> r.getMeta()).map(m -> m.getExternalKey()).orElse(null)).build());
            return Optional.ofNullable(transfer).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<? extends AssetPayout> assetPayout(CalculateTransferInstruction instruction) {
            return MapperS.of((Object)((AssetPayout)MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getCollateral", economicTerms -> economicTerms.getCollateral()).mapC("getCollateralPortfolio", collateral -> collateral.getCollateralPortfolio()).map("getValue", _f -> _f.getValue()).mapC("getCollateralPosition", collateralPortfolio -> collateralPortfolio.getCollateralPosition()).map("getProduct", position -> position.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getAssetPayout", payout -> payout.getAssetPayout()).get()));
        }

        @Override
        protected Mapper<? extends QuantitySchedule> tradeQuantity(CalculateTransferInstruction instruction) {
            return MapperS.of((Object)((QuantitySchedule)MapperC.of(this.filterQuantityByFinancialUnit.evaluate(MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("getValue", _f -> _f.getValue()).getMulti(), (FinancialUnitEnum)((Object)MapperS.of((Object)((Object)FinancialUnitEnum.SHARE)).get()))).get()));
        }

        @Override
        protected Mapper<? extends Quantity> securityQuantity(CalculateTransferInstruction instruction) {
            return MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)instruction).map("getQuantity", calculateTransferInstruction -> calculateTransferInstruction.getQuantity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)instruction).map("getQuantity", calculateTransferInstruction -> calculateTransferInstruction.getQuantity());
                }
                return MapperS.of((Object)NonNegativeQuantity.builder().setValue((BigDecimal)MapperS.of((Object)((QuantitySchedule)this.tradeQuantity(instruction).get())).map("getValue", measureBase -> measureBase.getValue()).get()).setUnit((UnitType)MapperS.of((Object)((QuantitySchedule)this.tradeQuantity(instruction).get())).map("getUnit", measureBase -> measureBase.getUnit()).get()).build());
            });
        }

        @Override
        protected Mapper<? extends PriceSchedule> securityPrice(CalculateTransferInstruction instruction) {
            return MapperS.of((Object)this.filterPrice.evaluate(MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("getValue", _f -> _f.getValue()).getMulti(), (PriceTypeEnum)((Object)MapperS.of((Object)((Object)PriceTypeEnum.ASSET_PRICE)).get()), Optional.ofNullable(null).map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.emptyList()), null));
        }
    }
}

