/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="ActionEnum")
public enum ActionEnum {
    NEW("New"),
    CORRECT("Correct"),
    CANCEL("Cancel");

    private static Map<String, ActionEnum> values;
    private final String rosettaName;
    private final String displayName;

    private ActionEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private ActionEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static ActionEnum fromDisplayName(String name) {
        ActionEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, ActionEnum> map = new ConcurrentHashMap<String, ActionEnum>();
        for (ActionEnum instance : ActionEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

