/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.processor;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.util.PathUtils;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.util.List;

public class ProductIdentifierSourceMappingProcessor
extends MappingProcessor {
    public ProductIdentifierSourceMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path synonymPath, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent) {
        MappingProcessorUtils.getNonNullMappingForModelPath((List)this.getMappings(), (Path)PathUtils.toPath((RosettaPath)this.getModelPath().newSubPath("value"))).map(m -> m.getXmlPath()).ifPresent(xmlPath -> {
            ProductIdentifier.ProductIdentifierBuilder productIdentifierBuilder = (ProductIdentifier.ProductIdentifierBuilder)parent;
            FieldWithMetaString.FieldWithMetaStringBuilder productIdentifierValueBuilder = (FieldWithMetaString.FieldWithMetaStringBuilder)builder;
            this.updateSchemeAndSource((Path)xmlPath, productIdentifierBuilder, productIdentifierValueBuilder);
            if (productIdentifierBuilder.getSource() == null) {
                productIdentifierBuilder.setSource(ProductIdTypeEnum.OTHER);
            }
        });
    }

    protected void updateSchemeAndSource(Path xmlPath, ProductIdentifier.ProductIdentifierBuilder productIdentifierBuilder, FieldWithMetaString.FieldWithMetaStringBuilder productIdentifierValueBuilder) {
        this.setValueAndUpdateMappings(xmlPath.addElement("instrumentIdScheme"), xmlValue -> {
            productIdentifierValueBuilder.getOrCreateMeta().setScheme((String)xmlValue);
            productIdentifierBuilder.setSource(this.getSourceEnum((String)xmlValue));
        });
        this.setValueAndUpdateMappings(xmlPath.addElement("productIdScheme"), xmlValue -> {
            productIdentifierValueBuilder.getOrCreateMeta().setScheme((String)xmlValue);
            productIdentifierBuilder.setSource(this.getSourceEnum((String)xmlValue));
        });
        if (xmlPath.endsWith(new String[]{"description"})) {
            productIdentifierBuilder.setSource(ProductIdTypeEnum.NAME);
        }
    }

    protected ProductIdTypeEnum getSourceEnum(String scheme) {
        if (scheme.contains("CUSIP")) {
            return ProductIdTypeEnum.CUSIP;
        }
        if (scheme.contains("ISIN")) {
            return ProductIdTypeEnum.ISIN;
        }
        if (scheme.contains("RIC")) {
            return ProductIdTypeEnum.RIC;
        }
        if (scheme.contains("Bloomberg")) {
            return ProductIdTypeEnum.BBGID;
        }
        if (scheme.contains("commodity-reference-price")) {
            return ProductIdTypeEnum.ISDACRP;
        }
        if (scheme.contains("iso4914")) {
            return ProductIdTypeEnum.UPI;
        }
        return ProductIdTypeEnum.OTHER;
    }
}

