/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="DebtClassEnum")
public enum DebtClassEnum {
    ASSET_BACKED("AssetBacked"),
    CONVERTIBLE("Convertible"),
    REG_CAP("RegCap"),
    STRUCTURED("Structured"),
    VANILLA("Vanilla"),
    HOLDER_CONVERTIBLE("HolderConvertible"),
    HOLDER_EXCHANGEABLE("HolderExchangeable"),
    ISSUER_CONVERTIBLE("IssuerConvertible"),
    ISSUER_EXCHANGEABLE("IssuerExchangeable");

    private static Map<String, DebtClassEnum> values;
    private final String rosettaName;
    private final String displayName;

    private DebtClassEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private DebtClassEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static DebtClassEnum fromDisplayName(String name) {
        DebtClassEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, DebtClassEnum> map = new ConcurrentHashMap<String, DebtClassEnum>();
        for (DebtClassEnum instance : DebtClassEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

