/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.functions;

import cdm.base.math.QuantitySchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=FilterQuantityByCurrencyExistsDefault.class)
public abstract class FilterQuantityByCurrencyExists
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public List<? extends QuantitySchedule> evaluate(List<? extends QuantitySchedule> quantities) {
        List filteredQuantities;
        List<QuantitySchedule.QuantityScheduleBuilder> filteredQuantitiesBuilder = this.doEvaluate(quantities);
        if (filteredQuantitiesBuilder == null) {
            filteredQuantities = null;
        } else {
            filteredQuantities = filteredQuantitiesBuilder.stream().map(QuantitySchedule::build).collect(Collectors.toList());
            this.objectValidator.validate(QuantitySchedule.class, filteredQuantities);
        }
        return filteredQuantities;
    }

    protected abstract List<QuantitySchedule.QuantityScheduleBuilder> doEvaluate(List<? extends QuantitySchedule> var1);

    public static class FilterQuantityByCurrencyExistsDefault
    extends FilterQuantityByCurrencyExists {
        @Override
        protected List<QuantitySchedule.QuantityScheduleBuilder> doEvaluate(List<? extends QuantitySchedule> quantities) {
            ArrayList<QuantitySchedule.QuantityScheduleBuilder> filteredQuantities = new ArrayList<QuantitySchedule.QuantityScheduleBuilder>();
            return this.assignOutput(filteredQuantities, quantities);
        }

        protected List<QuantitySchedule.QuantityScheduleBuilder> assignOutput(List<QuantitySchedule.QuantityScheduleBuilder> filteredQuantities, List<? extends QuantitySchedule> quantities) {
            List addVar = this.toBuilder(MapperC.of(quantities).filterItemNullSafe(item -> ExpressionOperators.exists((Mapper)item.map("getUnit", measureBase -> measureBase.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("getValue", _f -> _f.getValue())).get()).getMulti());
            filteredQuantities.addAll(addVar);
            return Optional.ofNullable(filteredQuantities).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

