# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['CollateralAgreementFloatingRate']

from cdm.product.asset.FloatingRateBase import FloatingRateBase

class CollateralAgreementFloatingRate(FloatingRateBase):
  """
  Represents the parameters needed to calculate the floating rate paid on collateral holdings.
  """
  negativeInterest: bool = Field(..., description="Specifies how negative rates should be applied. If rates go negative, should the payment be reversed (true) or zeroed out (false)?")
  """
  Specifies how negative rates should be applied.  If rates go negative, should the payment be reversed (true) or zeroed out (false)?
  """
  compressibleSpread: bool = Field(..., description="Specifies how spreads should be applied in a low/negative rate environment. If true, spread is applied only if rate is positive.")
  """
  Specifies how spreads should be applied in a low/negative rate environment.  If true, spread is applied only if rate is positive.
  """


CollateralAgreementFloatingRate.update_forward_refs()
