package cdm.product.template.validation;

import cdm.product.template.AutomaticExercise;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class AutomaticExerciseValidator implements Validator<AutomaticExercise> {

	@Override
	public ValidationResult<AutomaticExercise> validate(RosettaPath path, AutomaticExercise o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("thresholdRate", (BigDecimal) o.getThresholdRate() != null ? 1 : 0, 0, 1), 
				checkCardinality("isApplicable", (Boolean) o.getIsApplicable() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("AutomaticExercise", ValidationType.CARDINALITY, "AutomaticExercise", path, "", error);
		}
		return success("AutomaticExercise", ValidationType.CARDINALITY, "AutomaticExercise", path, "");
	}

}
