package cdm.product.asset.validation.datarule;

import cdm.product.asset.DividendPayoutRatio;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.0.0
 */
@RosettaDataRule("DividendPayoutRatioDividendPayoutRatioTotal")
@ImplementedBy(DividendPayoutRatioDividendPayoutRatioTotal.Default.class)
public interface DividendPayoutRatioDividendPayoutRatioTotal extends Validator<DividendPayoutRatio> {
	
	String NAME = "DividendPayoutRatioDividendPayoutRatioTotal";
	String DEFINITION = "totalRatio >= 0 and totalRatio <= 1";
	
	ValidationResult<DividendPayoutRatio> validate(RosettaPath path, DividendPayoutRatio dividendPayoutRatio);
	
	class Default implements DividendPayoutRatioDividendPayoutRatioTotal {
	
		@Override
		public ValidationResult<DividendPayoutRatio> validate(RosettaPath path, DividendPayoutRatio dividendPayoutRatio) {
			ComparisonResult result = executeDataRule(dividendPayoutRatio);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "DividendPayoutRatio", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null) {
				failureMessage = "Condition " + NAME + " failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "DividendPayoutRatio", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(DividendPayoutRatio dividendPayoutRatio) {
			try {
				ComparisonResult result = greaterThanEquals(MapperS.of(dividendPayoutRatio).<BigDecimal>map("getTotalRatio", _dividendPayoutRatio -> _dividendPayoutRatio.getTotalRatio()), MapperS.of(Integer.valueOf(0)), CardinalityOperator.All).and(lessThanEquals(MapperS.of(dividendPayoutRatio).<BigDecimal>map("getTotalRatio", _dividendPayoutRatio -> _dividendPayoutRatio.getTotalRatio()), MapperS.of(Integer.valueOf(1)), CardinalityOperator.All));
				return result.get() == null ? ComparisonResult.success() : result;
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements DividendPayoutRatioDividendPayoutRatioTotal {
	
		@Override
		public ValidationResult<DividendPayoutRatio> validate(RosettaPath path, DividendPayoutRatio dividendPayoutRatio) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "DividendPayoutRatio", path, DEFINITION);
		}
	}
}
