package cdm.product.asset.metafields;

import cdm.product.asset.FixedRateSpecification;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.BasicRosettaMetaData;
import com.rosetta.model.lib.meta.Reference;
import com.rosetta.model.lib.meta.ReferenceWithMeta;
import com.rosetta.model.lib.meta.ReferenceWithMeta.ReferenceWithMetaBuilder;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 1
 */
@RosettaDataType(value="ReferenceWithMetaFixedRateSpecification", builder=ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilderImpl.class, version="0.0.0")
public interface ReferenceWithMetaFixedRateSpecification extends RosettaModelObject, ReferenceWithMeta<FixedRateSpecification> {

	ReferenceWithMetaFixedRateSpecificationMeta metaData = new ReferenceWithMetaFixedRateSpecificationMeta();

	/*********************** Getter Methods  ***********************/
	FixedRateSpecification getValue();
	String getGlobalReference();
	String getExternalReference();
	Reference getReference();

	/*********************** Build Methods  ***********************/
	ReferenceWithMetaFixedRateSpecification build();
	
	ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder toBuilder();
	
	static ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder builder() {
		return new ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ReferenceWithMetaFixedRateSpecification> metaData() {
		return metaData;
	}
	
	@Override
	default Class<? extends ReferenceWithMetaFixedRateSpecification> getType() {
		return ReferenceWithMetaFixedRateSpecification.class;
	}
	
	@Override
	default Class<FixedRateSpecification> getValueType() {
		return FixedRateSpecification.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("globalReference"), String.class, getGlobalReference(), this, AttributeMeta.META);
		processor.processBasic(path.newSubPath("externalReference"), String.class, getExternalReference(), this, AttributeMeta.META);
		
		processRosetta(path.newSubPath("value"), processor, FixedRateSpecification.class, getValue());
		processRosetta(path.newSubPath("reference"), processor, Reference.class, getReference());
	}
	

	/*********************** Builder Interface  ***********************/
	interface ReferenceWithMetaFixedRateSpecificationBuilder extends ReferenceWithMetaFixedRateSpecification, RosettaModelObjectBuilder, ReferenceWithMeta.ReferenceWithMetaBuilder<FixedRateSpecification> {
		FixedRateSpecification.FixedRateSpecificationBuilder getOrCreateValue();
		FixedRateSpecification.FixedRateSpecificationBuilder getValue();
		Reference.ReferenceBuilder getOrCreateReference();
		Reference.ReferenceBuilder getReference();
		ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder setValue(FixedRateSpecification value);
		ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder setGlobalReference(String globalReference);
		ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder setExternalReference(String externalReference);
		ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder setReference(Reference reference);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			
			processor.processBasic(path.newSubPath("globalReference"), String.class, getGlobalReference(), this, AttributeMeta.META);
			processor.processBasic(path.newSubPath("externalReference"), String.class, getExternalReference(), this, AttributeMeta.META);
			
			processRosetta(path.newSubPath("value"), processor, FixedRateSpecification.FixedRateSpecificationBuilder.class, getValue());
			processRosetta(path.newSubPath("reference"), processor, Reference.ReferenceBuilder.class, getReference());
		}
		

		ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder prune();
	}

	/*********************** Immutable Implementation of ReferenceWithMetaFixedRateSpecification  ***********************/
	class ReferenceWithMetaFixedRateSpecificationImpl implements ReferenceWithMetaFixedRateSpecification {
		private final FixedRateSpecification value;
		private final String globalReference;
		private final String externalReference;
		private final Reference reference;
		
		protected ReferenceWithMetaFixedRateSpecificationImpl(ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder builder) {
			this.value = ofNullable(builder.getValue()).map(f->f.build()).orElse(null);
			this.globalReference = builder.getGlobalReference();
			this.externalReference = builder.getExternalReference();
			this.reference = ofNullable(builder.getReference()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("value")
		public FixedRateSpecification getValue() {
			return value;
		}
		
		@Override
		@RosettaAttribute("globalReference")
		public String getGlobalReference() {
			return globalReference;
		}
		
		@Override
		@RosettaAttribute("externalReference")
		public String getExternalReference() {
			return externalReference;
		}
		
		@Override
		@RosettaAttribute("address")
		public Reference getReference() {
			return reference;
		}
		
		@Override
		public ReferenceWithMetaFixedRateSpecification build() {
			return this;
		}
		
		@Override
		public ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder toBuilder() {
			ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder builder) {
			ofNullable(getValue()).ifPresent(builder::setValue);
			ofNullable(getGlobalReference()).ifPresent(builder::setGlobalReference);
			ofNullable(getExternalReference()).ifPresent(builder::setExternalReference);
			ofNullable(getReference()).ifPresent(builder::setReference);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ReferenceWithMetaFixedRateSpecification _that = getType().cast(o);
		
			if (!Objects.equals(value, _that.getValue())) return false;
			if (!Objects.equals(globalReference, _that.getGlobalReference())) return false;
			if (!Objects.equals(externalReference, _that.getExternalReference())) return false;
			if (!Objects.equals(reference, _that.getReference())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (value != null ? value.hashCode() : 0);
			_result = 31 * _result + (globalReference != null ? globalReference.hashCode() : 0);
			_result = 31 * _result + (externalReference != null ? externalReference.hashCode() : 0);
			_result = 31 * _result + (reference != null ? reference.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ReferenceWithMetaFixedRateSpecification {" +
				"value=" + this.value + ", " +
				"globalReference=" + this.globalReference + ", " +
				"externalReference=" + this.externalReference + ", " +
				"reference=" + this.reference +
			'}';
		}
	}

	/*********************** Builder Implementation of ReferenceWithMetaFixedRateSpecification  ***********************/
	class ReferenceWithMetaFixedRateSpecificationBuilderImpl implements ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder {
	
		protected FixedRateSpecification.FixedRateSpecificationBuilder value;
		protected String globalReference;
		protected String externalReference;
		protected Reference.ReferenceBuilder reference;
	
		public ReferenceWithMetaFixedRateSpecificationBuilderImpl() {
		}
	
		@Override
		@RosettaAttribute("value")
		public FixedRateSpecification.FixedRateSpecificationBuilder getValue() {
			return value;
		}
		
		@Override
		public FixedRateSpecification.FixedRateSpecificationBuilder getOrCreateValue() {
			FixedRateSpecification.FixedRateSpecificationBuilder result;
			if (value!=null) {
				result = value;
			}
			else {
				result = value = FixedRateSpecification.builder();
			}
			
			return result;
		}
		@Override
		@RosettaAttribute("globalReference")
		public String getGlobalReference() {
			return globalReference;
		}
		
		@Override
		@RosettaAttribute("externalReference")
		public String getExternalReference() {
			return externalReference;
		}
		
		@Override
		@RosettaAttribute("address")
		public Reference.ReferenceBuilder getReference() {
			return reference;
		}
		
		@Override
		public Reference.ReferenceBuilder getOrCreateReference() {
			Reference.ReferenceBuilder result;
			if (reference!=null) {
				result = reference;
			}
			else {
				result = reference = Reference.builder();
			}
			
			return result;
		}
	
		@Override
		@RosettaAttribute("value")
		public ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder setValue(FixedRateSpecification value) {
			this.value = value==null?null:value.toBuilder();
			return this;
		}
		@Override
		@RosettaAttribute("globalReference")
		public ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder setGlobalReference(String globalReference) {
			this.globalReference = globalReference==null?null:globalReference;
			return this;
		}
		@Override
		@RosettaAttribute("externalReference")
		public ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder setExternalReference(String externalReference) {
			this.externalReference = externalReference==null?null:externalReference;
			return this;
		}
		@Override
		@RosettaAttribute("address")
		public ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder setReference(Reference reference) {
			this.reference = reference==null?null:reference.toBuilder();
			return this;
		}
		
		@Override
		public ReferenceWithMetaFixedRateSpecification build() {
			return new ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationImpl(this);
		}
		
		@Override
		public ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder prune() {
			if (value!=null && !value.prune().hasData()) value = null;
			if (reference!=null && !reference.prune().hasData()) reference = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getValue()!=null && getValue().hasData()) return true;
			if (getGlobalReference()!=null) return true;
			if (getExternalReference()!=null) return true;
			if (getReference()!=null && getReference().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder o = (ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder) other;
			
			merger.mergeRosetta(getValue(), o.getValue(), this::setValue);
			merger.mergeRosetta(getReference(), o.getReference(), this::setReference);
			
			merger.mergeBasic(getGlobalReference(), o.getGlobalReference(), this::setGlobalReference);
			merger.mergeBasic(getExternalReference(), o.getExternalReference(), this::setExternalReference);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ReferenceWithMetaFixedRateSpecification _that = getType().cast(o);
		
			if (!Objects.equals(value, _that.getValue())) return false;
			if (!Objects.equals(globalReference, _that.getGlobalReference())) return false;
			if (!Objects.equals(externalReference, _that.getExternalReference())) return false;
			if (!Objects.equals(reference, _that.getReference())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (value != null ? value.hashCode() : 0);
			_result = 31 * _result + (globalReference != null ? globalReference.hashCode() : 0);
			_result = 31 * _result + (externalReference != null ? externalReference.hashCode() : 0);
			_result = 31 * _result + (reference != null ? reference.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ReferenceWithMetaFixedRateSpecificationBuilder {" +
				"value=" + this.value + ", " +
				"globalReference=" + this.globalReference + ", " +
				"externalReference=" + this.externalReference + ", " +
				"reference=" + this.reference +
			'}';
		}
	}
}

class ReferenceWithMetaFixedRateSpecificationMeta extends BasicRosettaMetaData<ReferenceWithMetaFixedRateSpecification>{

}
