package cdm.observable.asset.validation;

import cdm.observable.asset.SettlementRateOption;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class SettlementRateOptionTypeFormatValidator implements Validator<SettlementRateOption> {

	@Override
	public ValidationResult<SettlementRateOption> validate(RosettaPath path, SettlementRateOption o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("SettlementRateOption", ValidationType.TYPE_FORMAT, "SettlementRateOption", path, "", error);
		}
		return success("SettlementRateOption", ValidationType.TYPE_FORMAT, "SettlementRateOption", path, "");
	}

}
