package cdm.observable.asset.fro.validation;

import cdm.observable.asset.fro.FloatingRateIndexCalculationDefaults;
import cdm.observable.asset.fro.FloatingRateIndexDefinition;
import cdm.observable.asset.fro.FloatingRateIndexIdentification;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class FloatingRateIndexDefinitionValidator implements Validator<FloatingRateIndexDefinition> {

	@Override
	public ValidationResult<FloatingRateIndexDefinition> validate(RosettaPath path, FloatingRateIndexDefinition o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("fro", (FloatingRateIndexIdentification) o.getFro() != null ? 1 : 0, 1, 1), 
				checkCardinality("calculationDefaults", (FloatingRateIndexCalculationDefaults) o.getCalculationDefaults() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("FloatingRateIndexDefinition", ValidationType.CARDINALITY, "FloatingRateIndexDefinition", path, "", error);
		}
		return success("FloatingRateIndexDefinition", ValidationType.CARDINALITY, "FloatingRateIndexDefinition", path, "");
	}

}
