package cdm.legaldocumentation.master.validation;

import cdm.legaldocumentation.master.MasterConfirmationBase;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class MasterConfirmationBaseValidator implements Validator<MasterConfirmationBase> {

	@Override
	public ValidationResult<MasterConfirmationBase> validate(RosettaPath path, MasterConfirmationBase o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("MasterConfirmationBase", ValidationType.CARDINALITY, "MasterConfirmationBase", path, "", error);
		}
		return success("MasterConfirmationBase", ValidationType.CARDINALITY, "MasterConfirmationBase", path, "");
	}

}
