package cdm.legaldocumentation.csa.validation;

import cdm.legaldocumentation.csa.CollateralTransferAgreementElections;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class CollateralTransferAgreementElectionsTypeFormatValidator implements Validator<CollateralTransferAgreementElections> {

	@Override
	public ValidationResult<CollateralTransferAgreementElections> validate(RosettaPath path, CollateralTransferAgreementElections o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("CollateralTransferAgreementElections", ValidationType.TYPE_FORMAT, "CollateralTransferAgreementElections", path, "", error);
		}
		return success("CollateralTransferAgreementElections", ValidationType.TYPE_FORMAT, "CollateralTransferAgreementElections", path, "");
	}

}
