package cdm.legaldocumentation.common.validation;

import cdm.legaldocumentation.common.UmbrellaAgreementEntity;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.metafields.FieldWithMetaString;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class UmbrellaAgreementEntityValidator implements Validator<UmbrellaAgreementEntity> {

	@Override
	public ValidationResult<UmbrellaAgreementEntity> validate(RosettaPath path, UmbrellaAgreementEntity o) {
		/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkCardinality("name", (FieldWithMetaString) o.getName() != null ? 1 : 0, 1, 1), 
				checkCardinality("terms", (String) o.getTerms() != null ? 1 : 0, 0, 1)
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("UmbrellaAgreementEntity", ValidationType.CARDINALITY, "UmbrellaAgreementEntity", path, "", error);
		}
		return success("UmbrellaAgreementEntity", ValidationType.CARDINALITY, "UmbrellaAgreementEntity", path, "");
	}

}
