package cdm.base.math.validation;

import cdm.base.math.UnitType;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;

public class UnitTypeTypeFormatValidator implements Validator<UnitType> {

	@Override
	public ValidationResult<UnitType> validate(RosettaPath path, UnitType o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("UnitType", ValidationType.TYPE_FORMAT, "UnitType", path, "", error);
		}
		return success("UnitType", ValidationType.TYPE_FORMAT, "UnitType", path, "");
	}

}
