/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.productdataprovider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ClassLoaderDataSource {
    private final ClassLoader classLoader;

    public ClassLoaderDataSource(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Document loadDocument(String resourcePath, DocumentBuilder documentBuilder) {
        URL url = this.getResourceUrl(resourcePath);
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException("Cannot parse xml resource '" + resourcePath + "'", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public InputStream getResourceAsStream(String resourceName) {
        return this.getClassLoader().getResourceAsStream(resourceName);
    }

    public String getLastModificationStamp(String resourcePath) {
        URLConnection connection;
        URL url = this.getResourceUrl(resourcePath);
        try {
            connection = url.openConnection();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot open a connection to resource '" + resourcePath + "'", e);
        }
        if (connection instanceof JarURLConnection) {
            URI jarUri;
            JarURLConnection jarUrlConnection = (JarURLConnection)connection;
            URL jarUrl = jarUrlConnection.getJarFileURL();
            try {
                jarUri = jarUrl.toURI();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            File jarFile = new File(jarUri);
            return "" + jarFile.lastModified();
        }
        File tocFile = new File(url.getFile());
        return "" + tocFile.lastModified();
    }

    private URL getResourceUrl(String resourcePath) {
        URL url = this.getClassLoader().getResource(resourcePath);
        if (url == null) {
            throw new IllegalArgumentException("Cannot find resource '" + resourcePath + "'");
        }
        return url;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

