/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.ArrayList;
import java.util.List;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.values.DefaultInternationalString;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class MultiValueXmlHelper
extends Enum<MultiValueXmlHelper> {
    public static final String XML_TAG_MULTIVALUE = "MultiValue";
    public static final String XML_TAG_VALUE = "Value";
    private static final /* synthetic */ MultiValueXmlHelper[] $VALUES;

    public static MultiValueXmlHelper[] values() {
        return (MultiValueXmlHelper[])$VALUES.clone();
    }

    public static MultiValueXmlHelper valueOf(String name) {
        return Enum.valueOf(MultiValueXmlHelper.class, name);
    }

    public static List<String> getValuesFromXML(Element attrValueElement) {
        Element value = XmlUtil.getFirstElement(attrValueElement, XML_TAG_VALUE);
        MultiValueXmlHelper.assertElementExists(value, XML_TAG_VALUE);
        Element multiValueElement = XmlUtil.getFirstElement(value, XML_TAG_MULTIVALUE);
        MultiValueXmlHelper.assertElementExists(multiValueElement, XML_TAG_MULTIVALUE);
        ArrayList<String> list = new ArrayList<String>();
        NodeList valueNodeList = multiValueElement.getElementsByTagName(XML_TAG_VALUE);
        for (int i = 0; i < valueNodeList.getLength(); ++i) {
            Element valueElement = (Element)valueNodeList.item(i);
            list.add(ValueToXmlHelper.getValueFromElement(valueElement));
        }
        return list;
    }

    public static List<DefaultInternationalString> getInternationalStringsFromXML(Element attrValueElement) {
        Element value = XmlUtil.getFirstElement(attrValueElement, XML_TAG_VALUE);
        MultiValueXmlHelper.assertElementExists(value, XML_TAG_VALUE);
        Element multiValueElement = XmlUtil.getFirstElement(value, XML_TAG_MULTIVALUE);
        MultiValueXmlHelper.assertElementExists(multiValueElement, XML_TAG_MULTIVALUE);
        ArrayList<DefaultInternationalString> list = new ArrayList<DefaultInternationalString>();
        NodeList valueNodeList = multiValueElement.getElementsByTagName(XML_TAG_VALUE);
        for (int i = 0; i < valueNodeList.getLength(); ++i) {
            Element valueElement = (Element)valueNodeList.item(i);
            list.add(ValueToXmlHelper.getInternationalStringFromElement(XmlUtil.getFirstElement(valueElement, "InternationalString")));
        }
        return list;
    }

    private static void assertElementExists(Element element, String xmlTagName) {
        if (element == null) {
            throw new NullPointerException("Inconsistent XML content. Element \"" + xmlTagName + "\" was expected, but could not be found found.");
        }
    }

    public static void addValuesToElement(Element element, List<String> stringList) {
        Element outerValueElement = element.getOwnerDocument().createElement(XML_TAG_VALUE);
        element.appendChild(outerValueElement);
        Element multiValueElement = outerValueElement.getOwnerDocument().createElement(XML_TAG_MULTIVALUE);
        outerValueElement.appendChild(multiValueElement);
        for (String stringValue : stringList) {
            ValueToXmlHelper.addValueToElement(stringValue, multiValueElement, XML_TAG_VALUE);
        }
    }

    public static void addInternationalStringsToElement(Element element, List<DefaultInternationalString> internationalStringList) {
        Element outerValueElement = element.getOwnerDocument().createElement(XML_TAG_VALUE);
        element.appendChild(outerValueElement);
        Element multiValueElement = outerValueElement.getOwnerDocument().createElement(XML_TAG_MULTIVALUE);
        outerValueElement.appendChild(multiValueElement);
        for (DefaultInternationalString internationalStringValue : internationalStringList) {
            ValueToXmlHelper.addInternationalStringToElement(internationalStringValue, multiValueElement, XML_TAG_VALUE);
        }
    }

    private static /* synthetic */ MultiValueXmlHelper[] $values() {
        return new MultiValueXmlHelper[0];
    }

    static {
        $VALUES = MultiValueXmlHelper.$values();
    }
}

