/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.faktorips.runtime.IConfigurableModelObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IProductComponentLink;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.IllegalRepositoryModificationException;
import org.faktorips.runtime.formula.IFormulaEvaluator;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.FormulaHandler;
import org.faktorips.runtime.internal.IXmlPersistenceSupport;
import org.faktorips.runtime.internal.ProductComponent;
import org.faktorips.runtime.internal.ProductComponentXmlUtil;
import org.faktorips.runtime.internal.RuntimeObject;
import org.faktorips.runtime.internal.ValidationRules;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.valueset.IntegerRange;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class ProductComponentGeneration
extends RuntimeObject
implements IProductComponentGeneration,
IXmlPersistenceSupport {
    private ProductComponent productCmpt;
    private DateTime validFrom;
    private final FormulaHandler formulaHandler;
    private final ValidationRules validationRules;

    public ProductComponentGeneration(ProductComponent productCmpt) {
        this.productCmpt = productCmpt;
        this.formulaHandler = new FormulaHandler(this, this.getRepository());
        this.validationRules = new ValidationRules(this);
    }

    @Override
    public IConfigurableModelObject createPolicyComponent() {
        throw new RuntimeException("Product component does not configure a policy component.");
    }

    @Override
    public final IProductComponent getProductComponent() {
        return this.productCmpt;
    }

    @Override
    public final IProductComponentGeneration getPreviousGeneration() {
        return this.getRepository().getPreviousProductComponentGeneration(this);
    }

    @Override
    public final IProductComponentGeneration getNextGeneration() {
        return this.getRepository().getNextProductComponentGeneration(this);
    }

    @Override
    public IRuntimeRepository getRepository() {
        return this.productCmpt.getRepository();
    }

    public final long getValidFromInMillisec(TimeZone zone) {
        return this.validFrom.toDate(zone).getTime();
    }

    @Override
    public DateTime getValidFrom() {
        return this.validFrom;
    }

    @Override
    public final Date getValidFrom(TimeZone zone) {
        return this.validFrom.toDate(zone);
    }

    public void setValidFrom(DateTime newValidFrom) {
        if (this.getRepository() != null && !this.getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        if (newValidFrom == null) {
            throw new NullPointerException();
        }
        this.validFrom = newValidFrom;
    }

    public IFormulaEvaluator getFormulaEvaluator() {
        return this.formulaHandler.getFormulaEvaluator();
    }

    @Override
    public void initFromXml(Element genElement) {
        if (this.validFrom != null && this.getRepository() != null && !this.getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.validFrom = DateTime.parseIso(genElement.getAttribute("validFrom"));
        Map<String, Element> propertyElements = ProductComponentXmlUtil.getPropertyElements(genElement);
        this.doInitPropertiesFromXml(propertyElements);
        this.doInitTableUsagesFromXml(propertyElements);
        this.doInitReferencesFromXml(ProductComponentXmlUtil.getLinkElements(genElement));
        this.doInitFormulaFromXml(genElement);
        this.doInitValidationRuleConfigsFromXml(genElement);
        this.initExtensionPropertiesFromXml(genElement);
    }

    protected void doInitPropertiesFromXml(Map<String, Element> map) {
    }

    protected void doInitReferencesFromXml(Map<String, List<Element>> map) {
    }

    protected void doInitTableUsagesFromXml(Map<String, Element> map) {
    }

    protected void doInitFormulaFromXml(Element genElement) {
        this.formulaHandler.doInitFormulaFromXml(genElement);
    }

    protected boolean isFormulaAvailable(String formularSignature) {
        return this.formulaHandler.isFormulaAvailable(formularSignature);
    }

    protected void doInitValidationRuleConfigsFromXml(Element genElement) {
        this.validationRules.doInitValidationRuleConfigsFromXml(genElement);
    }

    protected Element getRangeElement(Element configElement) {
        Element valueSetElement = this.getValueSetElement(configElement);
        return XmlUtil.getFirstElement(valueSetElement, "Range");
    }

    protected NodeList getEnumNodeList(Element configElement) {
        Element enumElement = this.getEnumElement(configElement);
        return enumElement.getElementsByTagName("Value");
    }

    private Element getEnumElement(Element configElement) {
        Element valueSetElement = this.getValueSetElement(configElement);
        return XmlUtil.getFirstElement(valueSetElement, "Enum");
    }

    private Element getValueSetElement(Element configElement) {
        Objects.requireNonNull(configElement, "The parameter configElement must not be null.");
        return XmlUtil.findFirstElement(configElement, "ValueSet").orElseThrow(NullPointerException::new);
    }

    public static void addToCardinalityMap(Map<String, IntegerRange> cardinalityMap, String targetId, Element relationElement) {
        String maxStr = relationElement.getAttribute("maxCardinality");
        Integer maxCardinality = null;
        maxCardinality = "*".equals(maxStr) || "n".equals(maxStr.toLowerCase()) ? Integer.valueOf(Integer.MAX_VALUE) : Integer.valueOf(maxStr);
        Integer minCardinality = Integer.valueOf(relationElement.getAttribute("minCardinality"));
        cardinalityMap.put(targetId, IntegerRange.valueOf((Integer)minCardinality, (Integer)maxCardinality));
    }

    @Override
    public void setValidationRuleActivated(String ruleName, boolean active) {
        this.validationRules.setValidationRuleActivated(ruleName, active);
    }

    public String toString() {
        return this.getProductComponent().getId() + "-" + this.validFrom;
    }

    protected void setProductCmpt(ProductComponent productCmpt) {
        this.productCmpt = productCmpt;
    }

    @Override
    public IProductComponentLink<? extends IProductComponent> getLink(String linkName, IProductComponent target) {
        throw new RuntimeException("Not implemented yet.");
    }

    @Override
    public List<IProductComponentLink<? extends IProductComponent>> getLinks() {
        throw new RuntimeException("Not implemented yet.");
    }

    @Override
    public boolean isValidationRuleActivated(String ruleName) {
        return this.validationRules.isValidationRuleActivated(ruleName);
    }

    @Override
    public Element toXml(Document document) {
        Element genElement = document.createElement("ProductComponentGeneration");
        this.writePropertiesToXml(genElement);
        this.writeTableUsagesToXml(genElement);
        this.writeReferencesToXml(genElement);
        this.writeFormulaToXml(genElement);
        this.writeValidationRuleConfigsToXml(genElement);
        this.writeExtensionPropertiesToXml(genElement);
        return genElement;
    }

    protected void writeTableUsagesToXml(Element element) {
    }

    protected void writeTableUsageToXml(Element element, String structureUsage, String tableContentName) {
        ValueToXmlHelper.addTableUsageToElement(element, structureUsage, tableContentName);
    }

    protected void writeReferencesToXml(Element element) {
    }

    protected void writeFormulaToXml(Element element) {
        this.formulaHandler.writeFormulaToXml(element);
    }

    protected void writeValidationRuleConfigsToXml(Element genElement) {
        this.validationRules.writeValidationRuleConfigsToXml(genElement);
    }

    protected void writePropertiesToXml(Element generationElement) {
        throw new UnsupportedOperationException("The method toXml() is currently not supported, as the required methods were not generated. To activate toXml() please check your FIPS Builder properties and make sure \"Generated toXml Support\" is set to true.");
    }
}

