/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.NotSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.internal.DateTimeFormatValidator;
import org.everit.json.schema.internal.EmailFormatValidator;
import org.everit.json.schema.internal.HostnameFormatValidator;
import org.everit.json.schema.internal.IPV4Validator;
import org.everit.json.schema.internal.IPV6Validator;
import org.everit.json.schema.internal.URIFormatValidator;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.internal.DefaultSchemaClient;
import org.everit.json.schema.loader.internal.JSONPointer;
import org.everit.json.schema.loader.internal.ReferenceResolver;
import org.everit.json.schema.loader.internal.TypeBasedMultiplexer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SchemaLoader {
    private static final List<String> ARRAY_SCHEMA_PROPS = Arrays.asList("items", "additionalItems", "minItems", "maxItems", "uniqueItems");
    private static final Map<String, CombinedSchemaProvider> COMB_SCHEMA_PROVIDERS = new HashMap<String, CombinedSchemaProvider>(3);
    private static final List<String> NUMBER_SCHEMA_PROPS = Arrays.asList("minimum", "maximum", "minimumExclusive", "maximumExclusive", "multipleOf");
    private static final List<String> OBJECT_SCHEMA_PROPS = Arrays.asList("properties", "required", "minProperties", "maxProperties", "dependencies", "patternProperties", "additionalProperties");
    private static final List<String> STRING_SCHEMA_PROPS = Arrays.asList("minLength", "maxLength", "pattern", "format");
    private final SchemaClient httpClient;
    private URI id = null;
    private final Map<String, ReferenceSchema.Builder> pointerSchemas;
    private final JSONObject rootSchemaJson;
    private final JSONObject schemaJson;
    private final Map<String, FormatValidator> formatValidators;

    public static SchemaLoaderBuilder builder() {
        return new SchemaLoaderBuilder();
    }

    public static Schema load(JSONObject schemaJson) {
        return SchemaLoader.load(schemaJson, new DefaultSchemaClient());
    }

    public static Schema load(JSONObject schemaJson, SchemaClient httpClient) {
        SchemaLoader loader = SchemaLoader.builder().schemaJson(schemaJson).httpClient(httpClient).build();
        return loader.load().build();
    }

    static URI withoutFragment(String fullUri) {
        int hashmarkIdx = fullUri.indexOf(35);
        String rval = hashmarkIdx == -1 ? fullUri : fullUri.substring(0, hashmarkIdx);
        try {
            return new URI(rval);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public SchemaLoader(SchemaLoaderBuilder builder) {
        this.schemaJson = Objects.requireNonNull(builder.schemaJson, "schemaJson cannot be null");
        this.rootSchemaJson = Objects.requireNonNull(builder.getRootSchemaJson(), "rootSchemaJson cannot be null");
        URI id = builder.id;
        if (id == null && builder.schemaJson.has("id")) {
            try {
                id = new URI(builder.schemaJson.getString("id"));
            }
            catch (URISyntaxException | JSONException e) {
                throw new RuntimeException(e);
            }
        }
        this.id = id;
        this.httpClient = Objects.requireNonNull(builder.httpClient, "httpClient cannot be null");
        this.pointerSchemas = Objects.requireNonNull(builder.pointerSchemas, "pointerSchemas cannot be null");
        this.formatValidators = Objects.requireNonNull(builder.formatValidators, "formatValidators cannot be null");
    }

    @Deprecated
    SchemaLoader(String id, JSONObject schemaJson, JSONObject rootSchemaJson, Map<String, ReferenceSchema.Builder> pointerSchemas, SchemaClient httpClient) {
        this(SchemaLoader.builder().schemaJson(schemaJson).rootSchemaJson(rootSchemaJson).resolutionScope(id).httpClient(httpClient).pointerSchemas(pointerSchemas));
    }

    private void addDependencies(ObjectSchema.Builder builder, JSONObject deps) {
        Arrays.stream(JSONObject.getNames((JSONObject)deps)).forEach(ifPresent -> this.addDependency(builder, (String)ifPresent, deps.get(ifPresent)));
    }

    private void addDependency(ObjectSchema.Builder builder, String ifPresent, Object deps) {
        this.typeMultiplexer(deps).ifObject().then(obj -> builder.schemaDependency(ifPresent, (Schema)this.loadChild((JSONObject)obj).build())).ifIs(JSONArray.class).then(propNames -> IntStream.range(0, propNames.length()).mapToObj(i -> propNames.getString(i)).forEach(dependency -> builder.propertyDependency(ifPresent, (String)dependency))).requireAny();
    }

    private void addFormatValidator(StringSchema.Builder builder, String formatName) {
        this.getFormatValidator(formatName).ifPresent(builder::formatValidator);
    }

    private void addPropertySchemaDefinition(String keyOfObj, Object definition, ObjectSchema.Builder builder) {
        this.typeMultiplexer(definition).ifObject().then(obj -> builder.addPropertySchema(keyOfObj, (Schema)this.loadChild((JSONObject)obj).build())).requireAny();
    }

    private CombinedSchema.Builder buildAnyOfSchemaForMultipleTypes() {
        JSONArray subtypeJsons = this.schemaJson.getJSONArray("type");
        HashMap<String, Object> dummyJson = new HashMap<String, Object>();
        ArrayList<Schema> subschemas = new ArrayList<Schema>(subtypeJsons.length());
        for (int i = 0; i < subtypeJsons.length(); ++i) {
            Object subtypeJson = subtypeJsons.get(i);
            dummyJson.put("type", subtypeJson);
            JSONObject child = new JSONObject(dummyJson);
            subschemas.add((Schema)this.loadChild(child).build());
        }
        return CombinedSchema.anyOf(subschemas);
    }

    private ArraySchema.Builder buildArraySchema() {
        ArraySchema.Builder builder = ArraySchema.builder();
        this.ifPresent("minItems", Integer.class, builder::minItems);
        this.ifPresent("maxItems", Integer.class, builder::maxItems);
        this.ifPresent("uniqueItems", Boolean.class, builder::uniqueItems);
        if (this.schemaJson.has("additionalItems")) {
            this.typeMultiplexer("additionalItems", this.schemaJson.get("additionalItems")).ifIs(Boolean.class).then(builder::additionalItems).ifObject().then(jsonObj -> builder.schemaOfAdditionalItems((Schema)this.loadChild((JSONObject)jsonObj).build())).requireAny();
        }
        if (this.schemaJson.has("items")) {
            this.typeMultiplexer("items", this.schemaJson.get("items")).ifObject().then(itemSchema -> builder.allItemSchema((Schema)this.loadChild((JSONObject)itemSchema).build())).ifIs(JSONArray.class).then(arr -> this.buildTupleSchema(builder, (JSONArray)arr)).requireAny();
        }
        return builder;
    }

    private EnumSchema.Builder buildEnumSchema() {
        HashSet<Object> possibleValues = new HashSet<Object>();
        JSONArray arr = this.schemaJson.getJSONArray("enum");
        IntStream.range(0, arr.length()).mapToObj(arg_0 -> ((JSONArray)arr).get(arg_0)).forEach(possibleValues::add);
        return EnumSchema.builder().possibleValues(possibleValues);
    }

    private NotSchema.Builder buildNotSchema() {
        Object mustNotMatch = this.loadChild(this.schemaJson.getJSONObject("not")).build();
        return NotSchema.builder().mustNotMatch((Schema)mustNotMatch);
    }

    private NumberSchema.Builder buildNumberSchema() {
        NumberSchema.Builder builder = NumberSchema.builder();
        this.ifPresent("minimum", Number.class, builder::minimum);
        this.ifPresent("maximum", Number.class, builder::maximum);
        this.ifPresent("multipleOf", Number.class, builder::multipleOf);
        this.ifPresent("exclusiveMinimum", Boolean.class, builder::exclusiveMinimum);
        this.ifPresent("exclusiveMaximum", Boolean.class, builder::exclusiveMaximum);
        return builder;
    }

    private ObjectSchema.Builder buildObjectSchema() {
        JSONObject patternPropsJson;
        String[] patterns;
        ObjectSchema.Builder builder = ObjectSchema.builder();
        this.ifPresent("minProperties", Integer.class, builder::minProperties);
        this.ifPresent("maxProperties", Integer.class, builder::maxProperties);
        if (this.schemaJson.has("properties")) {
            this.typeMultiplexer(this.schemaJson.get("properties")).ifObject().then(propertyDefs -> this.populatePropertySchemas((JSONObject)propertyDefs, builder)).requireAny();
        }
        if (this.schemaJson.has("additionalProperties")) {
            this.typeMultiplexer("additionalProperties", this.schemaJson.get("additionalProperties")).ifIs(Boolean.class).then(builder::additionalProperties).ifObject().then(def -> builder.schemaOfAdditionalProperties((Schema)this.loadChild((JSONObject)def).build())).requireAny();
        }
        if (this.schemaJson.has("required")) {
            JSONArray requiredJson = this.schemaJson.getJSONArray("required");
            IntStream.range(0, requiredJson.length()).mapToObj(arg_0 -> ((JSONArray)requiredJson).getString(arg_0)).forEach(builder::addRequiredProperty);
        }
        if (this.schemaJson.has("patternProperties") && (patterns = JSONObject.getNames((JSONObject)(patternPropsJson = this.schemaJson.getJSONObject("patternProperties")))) != null) {
            for (String pattern : patterns) {
                builder.patternProperty(pattern, (Schema)this.loadChild(patternPropsJson.getJSONObject(pattern)).build());
            }
        }
        this.ifPresent("dependencies", JSONObject.class, deps -> this.addDependencies(builder, (JSONObject)deps));
        return builder;
    }

    private Schema.Builder<?> buildSchemaWithoutExplicitType() {
        if (this.schemaJson.length() == 0) {
            return EmptySchema.builder();
        }
        if (this.schemaJson.has("$ref")) {
            return this.lookupReference(this.schemaJson.getString("$ref"), this.schemaJson);
        }
        Schema.Builder<?> rval = this.sniffSchemaByProps();
        if (rval != null) {
            return rval;
        }
        if (this.schemaJson.has("not")) {
            return this.buildNotSchema();
        }
        return EmptySchema.builder();
    }

    private StringSchema.Builder buildStringSchema() {
        StringSchema.Builder builder = StringSchema.builder();
        this.ifPresent("minLength", Integer.class, builder::minLength);
        this.ifPresent("maxLength", Integer.class, builder::maxLength);
        this.ifPresent("pattern", String.class, builder::pattern);
        this.ifPresent("format", String.class, format -> this.addFormatValidator(builder, (String)format));
        return builder;
    }

    private void buildTupleSchema(ArraySchema.Builder builder, JSONArray itemSchema) {
        for (int i = 0; i < itemSchema.length(); ++i) {
            this.typeMultiplexer(itemSchema.get(i)).ifObject().then(schema -> builder.addItemSchema((Schema)this.loadChild((JSONObject)schema).build())).requireAny();
        }
    }

    JSONObject extend(JSONObject additional, JSONObject original) {
        String[] additionalNames = JSONObject.getNames((JSONObject)additional);
        if (additionalNames == null) {
            return original;
        }
        String[] originalNames = JSONObject.getNames((JSONObject)original);
        if (originalNames == null) {
            return additional;
        }
        JSONObject rval = new JSONObject();
        Arrays.stream(originalNames).forEach(name -> rval.put(name, original.get(name)));
        Arrays.stream(additionalNames).forEach(name -> rval.put(name, additional.get(name)));
        return rval;
    }

    Optional<FormatValidator> getFormatValidator(String format) {
        return Optional.ofNullable(this.formatValidators.get(format));
    }

    private <E> void ifPresent(String key, Class<E> expectedType, Consumer<E> consumer) {
        if (this.schemaJson.has(key)) {
            Object value = this.schemaJson.get(key);
            try {
                consumer.accept(value);
            }
            catch (ClassCastException e) {
                throw new SchemaException(key, expectedType, value);
            }
        }
    }

    public Schema.Builder<?> load() {
        Schema.Builder builder;
        if (this.schemaJson.has("enum")) {
            builder = this.buildEnumSchema();
        } else {
            builder = this.tryCombinedSchema();
            if (builder == null) {
                builder = !this.schemaJson.has("type") || this.schemaJson.has("$ref") ? this.buildSchemaWithoutExplicitType() : this.loadForType(this.schemaJson.get("type"));
            }
        }
        this.ifPresent("id", String.class, builder::id);
        this.ifPresent("title", String.class, builder::title);
        this.ifPresent("description", String.class, builder::description);
        return builder;
    }

    private Schema.Builder<?> loadChild(JSONObject childJson) {
        return this.selfBuilder().schemaJson(childJson).build().load();
    }

    private Schema.Builder<?> loadForExplicitType(String typeString) {
        switch (typeString) {
            case "string": {
                return this.buildStringSchema();
            }
            case "integer": {
                return this.buildNumberSchema().requiresInteger(true);
            }
            case "number": {
                return this.buildNumberSchema();
            }
            case "boolean": {
                return BooleanSchema.builder();
            }
            case "null": {
                return NullSchema.builder();
            }
            case "array": {
                return this.buildArraySchema();
            }
            case "object": {
                return this.buildObjectSchema();
            }
        }
        throw new SchemaException(String.format("unknown type: [%s]", typeString));
    }

    private Schema.Builder<?> loadForType(Object type) {
        if (type instanceof JSONArray) {
            return this.buildAnyOfSchemaForMultipleTypes();
        }
        if (type instanceof String) {
            return this.loadForExplicitType((String)type);
        }
        throw new SchemaException("type", Arrays.asList(JSONArray.class, String.class), type);
    }

    private Schema.Builder<?> lookupReference(String relPointerString, JSONObject ctx) {
        String absPointerString = ReferenceResolver.resolve(this.id, relPointerString).toString();
        if (this.pointerSchemas.containsKey(absPointerString)) {
            return this.pointerSchemas.get(absPointerString);
        }
        boolean isExternal = !absPointerString.startsWith("#");
        JSONPointer pointer = isExternal ? JSONPointer.forURL(this.httpClient, absPointerString) : JSONPointer.forDocument(this.rootSchemaJson, absPointerString);
        ReferenceSchema.Builder refBuilder = ReferenceSchema.builder();
        this.pointerSchemas.put(absPointerString, refBuilder);
        JSONPointer.QueryResult result = pointer.query();
        JSONObject resultObject = this.extend(this.withoutRef(ctx), result.getQueryResult());
        SchemaLoader childLoader = this.selfBuilder().resolutionScope(isExternal ? SchemaLoader.withoutFragment(absPointerString) : this.id).schemaJson(resultObject).rootSchemaJson(result.getContainingDocument()).build();
        Object referredSchema = childLoader.load().build();
        refBuilder.build().setReferredSchema((Schema)referredSchema);
        return refBuilder;
    }

    private void populatePropertySchemas(JSONObject propertyDefs, ObjectSchema.Builder builder) {
        String[] names = JSONObject.getNames((JSONObject)propertyDefs);
        if (names == null || names.length == 0) {
            return;
        }
        Arrays.stream(names).forEach(key -> this.addPropertySchemaDefinition((String)key, propertyDefs.get(key), builder));
    }

    private boolean schemaHasAnyOf(Collection<String> propNames) {
        return propNames.stream().filter(arg_0 -> ((JSONObject)this.schemaJson).has(arg_0)).findAny().isPresent();
    }

    private SchemaLoaderBuilder selfBuilder() {
        SchemaLoaderBuilder rval = SchemaLoader.builder().resolutionScope(this.id).schemaJson(this.schemaJson).rootSchemaJson(this.rootSchemaJson).pointerSchemas(this.pointerSchemas).httpClient(this.httpClient).formatValidators(this.formatValidators);
        return rval;
    }

    private Schema.Builder<?> sniffSchemaByProps() {
        if (this.schemaHasAnyOf(ARRAY_SCHEMA_PROPS)) {
            return this.buildArraySchema().requiresArray(false);
        }
        if (this.schemaHasAnyOf(OBJECT_SCHEMA_PROPS)) {
            return this.buildObjectSchema().requiresObject(false);
        }
        if (this.schemaHasAnyOf(NUMBER_SCHEMA_PROPS)) {
            return this.buildNumberSchema().requiresNumber(false);
        }
        if (this.schemaHasAnyOf(STRING_SCHEMA_PROPS)) {
            return this.buildStringSchema().requiresString(false);
        }
        return null;
    }

    private CombinedSchema.Builder tryCombinedSchema() {
        List presentKeys = COMB_SCHEMA_PROVIDERS.keySet().stream().filter(arg_0 -> ((JSONObject)this.schemaJson).has(arg_0)).collect(Collectors.toList());
        if (presentKeys.size() > 1) {
            throw new SchemaException(String.format("expected at most 1 of 'allOf', 'anyOf', 'oneOf', %d found", presentKeys.size()));
        }
        if (presentKeys.size() == 1) {
            String key = (String)presentKeys.get(0);
            JSONArray subschemaDefs = this.schemaJson.getJSONArray(key);
            Collection subschemas = IntStream.range(0, subschemaDefs.length()).mapToObj(arg_0 -> ((JSONArray)subschemaDefs).getJSONObject(arg_0)).map(this::loadChild).map(Schema.Builder::build).collect(Collectors.toList());
            CombinedSchema.Builder combinedSchema = (CombinedSchema.Builder)COMB_SCHEMA_PROVIDERS.get(key).apply(subschemas);
            Schema.Builder<?> baseSchema = this.schemaJson.has("type") ? this.loadForType(this.schemaJson.get("type")) : this.sniffSchemaByProps();
            if (baseSchema == null) {
                return combinedSchema;
            }
            return CombinedSchema.allOf(Arrays.asList(baseSchema.build(), combinedSchema.build()));
        }
        return null;
    }

    private TypeBasedMultiplexer typeMultiplexer(Object obj) {
        return this.typeMultiplexer(null, obj);
    }

    private TypeBasedMultiplexer typeMultiplexer(String keyOfObj, Object obj) {
        TypeBasedMultiplexer multiplexer = new TypeBasedMultiplexer(keyOfObj, obj, this.id);
        multiplexer.addResolutionScopeChangeListener(scope -> {
            this.id = scope;
        });
        return multiplexer;
    }

    JSONObject withoutRef(JSONObject original) {
        String[] names = JSONObject.getNames((JSONObject)original);
        if (names == null) {
            return original;
        }
        JSONObject rval = new JSONObject();
        Arrays.stream(names).filter(name -> !"$ref".equals(name)).forEach(name -> rval.put(name, original.get(name)));
        return rval;
    }

    static {
        COMB_SCHEMA_PROVIDERS.put("allOf", CombinedSchema::allOf);
        COMB_SCHEMA_PROVIDERS.put("anyOf", CombinedSchema::anyOf);
        COMB_SCHEMA_PROVIDERS.put("oneOf", CombinedSchema::oneOf);
    }

    public static class SchemaLoaderBuilder {
        SchemaClient httpClient = new DefaultSchemaClient();
        JSONObject schemaJson;
        JSONObject rootSchemaJson;
        Map<String, ReferenceSchema.Builder> pointerSchemas = new HashMap<String, ReferenceSchema.Builder>();
        URI id;
        Map<String, FormatValidator> formatValidators = new HashMap<String, FormatValidator>();

        public SchemaLoaderBuilder() {
            this.formatValidators.put("date-time", new DateTimeFormatValidator());
            this.formatValidators.put("uri", new URIFormatValidator());
            this.formatValidators.put("email", new EmailFormatValidator());
            this.formatValidators.put("ipv4", new IPV4Validator());
            this.formatValidators.put("ipv6", new IPV6Validator());
            this.formatValidators.put("hostname", new HostnameFormatValidator());
        }

        public SchemaLoaderBuilder addFormatValidator(String formatName, FormatValidator formatValidator) {
            this.formatValidators.put(formatName, formatValidator);
            return this;
        }

        public SchemaLoader build() {
            return new SchemaLoader(this);
        }

        public JSONObject getRootSchemaJson() {
            return this.rootSchemaJson == null ? this.schemaJson : this.rootSchemaJson;
        }

        public SchemaLoaderBuilder httpClient(SchemaClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public SchemaLoaderBuilder resolutionScope(String id) {
            try {
                return this.resolutionScope(new URI(id));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public SchemaLoaderBuilder resolutionScope(URI id) {
            this.id = id;
            return this;
        }

        SchemaLoaderBuilder pointerSchemas(Map<String, ReferenceSchema.Builder> pointerSchemas) {
            this.pointerSchemas = pointerSchemas;
            return this;
        }

        SchemaLoaderBuilder rootSchemaJson(JSONObject rootSchemaJson) {
            this.rootSchemaJson = rootSchemaJson;
            return this;
        }

        public SchemaLoaderBuilder schemaJson(JSONObject schemaJson) {
            this.schemaJson = schemaJson;
            return this;
        }

        SchemaLoaderBuilder formatValidators(Map<String, FormatValidator> formatValidators) {
            this.formatValidators = formatValidators;
            return this;
        }
    }

    @FunctionalInterface
    private static interface CombinedSchemaProvider
    extends Function<Collection<Schema>, CombinedSchema.Builder> {
    }
}

