/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;

public final class ReferenceResolver {
    private final String parentScope;
    private final String encounteredSegment;

    public static String resolve(String parentScope, String encounteredSegment) {
        return new ReferenceResolver(parentScope, encounteredSegment).resolve();
    }

    private ReferenceResolver(String parentScope, String encounteredSegment) {
        this.parentScope = Objects.requireNonNull(parentScope, "parentScope cannot be null");
        this.encounteredSegment = Objects.requireNonNull(encounteredSegment, "encounteredSegment cannot be null");
    }

    private String concat() {
        return this.parentScope + this.encounteredSegment;
    }

    private String handlePathIdAttr() {
        try {
            URL parentScopeURL = new URL(this.parentScope);
            StringBuilder newIdBuilder = new StringBuilder().append(parentScopeURL.getProtocol()).append("://").append(parentScopeURL.getHost());
            if (parentScopeURL.getPort() > -1) {
                newIdBuilder.append(":").append(parentScopeURL.getPort());
            }
            newIdBuilder.append(this.removeTrailingSegmentFrom(parentScopeURL.getPath())).append("/").append(this.encounteredSegment);
            return newIdBuilder.toString();
        }
        catch (MalformedURLException e1) {
            return this.concat();
        }
    }

    private String nonfragmentIdAttr() {
        try {
            URL url = new URL(this.encounteredSegment);
            return url.toExternalForm();
        }
        catch (MalformedURLException e) {
            return this.handlePathIdAttr();
        }
    }

    private String removeTrailingSegmentFrom(String path) {
        if (path.isEmpty() || "/".equals(path)) {
            return "";
        }
        return path.substring(0, path.lastIndexOf(47));
    }

    private String resolve() {
        if (this.encounteredSegment.startsWith("#")) {
            return this.concat();
        }
        return this.nonfragmentIdAttr();
    }
}

