/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;

public class CombinedSchema
extends Schema {
    public static final ValidationCriterion ALL_CRITERION = (subschemaCount, matchingCount) -> {
        if (matchingCount < subschemaCount) {
            throw new ValidationException(String.format("only %d subschema matches out of %d", matchingCount, subschemaCount));
        }
    };
    public static final ValidationCriterion ANY_CRITERION = (subschemaCount, matchingCount) -> {
        if (matchingCount == 0) {
            throw new ValidationException(String.format("no subschema matched out of the total %d subschemas", subschemaCount));
        }
    };
    public static final ValidationCriterion ONE_CRITERION = (subschemaCount, matchingCount) -> {
        if (matchingCount != 1) {
            throw new ValidationException(String.format("%d subschemas matched instead of one", matchingCount));
        }
    };
    private final Collection<Schema> subschemas;
    private final ValidationCriterion criterion;

    public static Builder allOf(Collection<Schema> schemas) {
        return CombinedSchema.builder(schemas).criterion(ALL_CRITERION);
    }

    public static Builder anyOf(Collection<Schema> schemas) {
        return CombinedSchema.builder(schemas).criterion(ANY_CRITERION);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Collection<Schema> subschemas) {
        return new Builder().subschemas(subschemas);
    }

    public static Builder oneOf(Collection<Schema> schemas) {
        return CombinedSchema.builder(schemas).criterion(ONE_CRITERION);
    }

    public CombinedSchema(Builder builder) {
        super(builder);
        this.criterion = Objects.requireNonNull(builder.criterion, "criterion cannot be null");
        this.subschemas = Objects.requireNonNull(builder.subschemas, "subschemas cannot be null");
    }

    public ValidationCriterion getCriterion() {
        return this.criterion;
    }

    public Collection<Schema> getSubschemas() {
        return this.subschemas;
    }

    private boolean succeeds(Schema schema, Object subject) {
        try {
            schema.validate(subject);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    @Override
    public void validate(Object subject) {
        int matchingCount = (int)this.subschemas.stream().filter(schema -> this.succeeds((Schema)schema, subject)).count();
        try {
            this.criterion.validate(this.subschemas.size(), matchingCount);
        }
        catch (ValidationException e) {
            throw new ValidationException((Schema)this, e.getMessage());
        }
    }

    @FunctionalInterface
    public static interface ValidationCriterion {
        public void validate(int var1, int var2);
    }

    public static class Builder
    extends Schema.Builder<CombinedSchema> {
        private ValidationCriterion criterion;
        private Collection<Schema> subschemas = new ArrayList<Schema>();

        @Override
        public CombinedSchema build() {
            return new CombinedSchema(this);
        }

        public Builder criterion(ValidationCriterion criterion) {
            this.criterion = criterion;
            return this;
        }

        public Builder subschema(Schema subschema) {
            this.subschemas.add(subschema);
            return this;
        }

        public Builder subschemas(Collection<Schema> subschemas) {
            this.subschemas = subschemas;
            return this;
        }
    }
}

