/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.entity.AbstractHttpEntity;
import org.esigate.http.HttpResponseUtils;

public class HttpServletRequestEntity
extends AbstractHttpEntity {
    private final HttpServletRequest request;
    private final long length;

    HttpServletRequestEntity(HttpServletRequest request) {
        String contentEncodingHeader;
        this.request = request;
        String contentLengthHeader = request.getHeader("Content-Length");
        this.length = contentLengthHeader != null ? Long.parseLong(contentLengthHeader) : -1L;
        String contentTypeHeader = request.getHeader("Content-Type");
        if (contentTypeHeader != null) {
            this.setContentType(contentTypeHeader);
        }
        if ((contentEncodingHeader = request.getHeader("Content-Encoding")) != null) {
            this.setContentEncoding(contentEncodingHeader);
        }
    }

    public boolean isRepeatable() {
        return false;
    }

    public long getContentLength() {
        return this.length;
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        return this.request.getInputStream();
    }

    public void writeTo(OutputStream outstream) throws IOException {
        HttpResponseUtils.writeTo((HttpEntity)this, (OutputStream)outstream);
    }

    public boolean isStreaming() {
        return true;
    }
}

