/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

@ManagedObject(value="Abstract implementation of the Connector Interface")
public abstract class AbstractConnector
extends ContainerLifeCycle
implements Connector,
Dumpable {
    protected final Logger LOG = Log.getLogger(this.getClass());
    private final Map<String, ConnectionFactory> _factories = new LinkedHashMap<String, ConnectionFactory>();
    private final Server _server;
    private final Executor _executor;
    private final Scheduler _scheduler;
    private final ByteBufferPool _byteBufferPool;
    private final Thread[] _acceptors;
    private final Set<EndPoint> _endpoints = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<EndPoint> _immutableEndPoints = Collections.unmodifiableSet(this._endpoints);
    private volatile CountDownLatch _stopping;
    private long _idleTimeout = 30000L;
    private String _defaultProtocol;
    private ConnectionFactory _defaultConnectionFactory;
    private String _name;

    public AbstractConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool pool, int acceptors, ConnectionFactory ... factories) {
        this._server = server;
        Executor executor2 = this._executor = executor != null ? executor : this._server.getThreadPool();
        if (scheduler == null) {
            scheduler = this._server.getBean(Scheduler.class);
        }
        Scheduler scheduler2 = this._scheduler = scheduler != null ? scheduler : new ScheduledExecutorScheduler();
        if (pool == null) {
            pool = this._server.getBean(ByteBufferPool.class);
        }
        this._byteBufferPool = pool != null ? pool : new ArrayByteBufferPool();
        this.addBean((Object)this._server, false);
        this.addBean(this._executor);
        if (executor == null) {
            this.unmanage(this._executor);
        }
        this.addBean(this._scheduler);
        this.addBean(this._byteBufferPool);
        for (ConnectionFactory factory : factories) {
            this.addConnectionFactory(factory);
        }
        int cores = Runtime.getRuntime().availableProcessors();
        if (acceptors < 0) {
            acceptors = 1 + cores / 16;
        }
        if (acceptors > 2 * cores) {
            this.LOG.warn("Acceptors should be <= 2*availableProcessors: " + this, new Object[0]);
        }
        this._acceptors = new Thread[acceptors];
    }

    @Override
    public Server getServer() {
        return this._server;
    }

    @Override
    public Executor getExecutor() {
        return this._executor;
    }

    @Override
    public ByteBufferPool getByteBufferPool() {
        return this._byteBufferPool;
    }

    @Override
    @ManagedAttribute(value="Idle timeout")
    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this._idleTimeout = idleTimeout;
    }

    @ManagedAttribute(value="number of acceptor threads")
    public int getAcceptors() {
        return this._acceptors.length;
    }

    @Override
    protected void doStart() throws Exception {
        this._defaultConnectionFactory = this.getConnectionFactory(this._defaultProtocol);
        if (this._defaultConnectionFactory == null) {
            throw new IllegalStateException("No protocol factory for default protocol: " + this._defaultProtocol);
        }
        super.doStart();
        this._stopping = new CountDownLatch(this._acceptors.length);
        for (int i = 0; i < this._acceptors.length; ++i) {
            this.getExecutor().execute(new Acceptor(i));
        }
        this.LOG.info("Started {}", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void interruptAcceptors() {
        AbstractConnector abstractConnector = this;
        synchronized (abstractConnector) {
            for (Thread thread : this._acceptors) {
                if (thread == null) continue;
                thread.interrupt();
            }
        }
    }

    @Override
    public Future<Void> shutdown() {
        return new FutureCallback(true);
    }

    @Override
    protected void doStop() throws Exception {
        this.interruptAcceptors();
        long stopTimeout = this.getStopTimeout();
        CountDownLatch stopping = this._stopping;
        if (stopTimeout > 0L && stopping != null) {
            stopping.await(stopTimeout, TimeUnit.MILLISECONDS);
        }
        this._stopping = null;
        super.doStop();
        this.LOG.info("Stopped {}", this);
    }

    public void join() throws InterruptedException {
        this.join(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(long timeout) throws InterruptedException {
        AbstractConnector abstractConnector = this;
        synchronized (abstractConnector) {
            for (Thread thread : this._acceptors) {
                if (thread == null) continue;
                thread.join(timeout);
            }
        }
    }

    protected abstract void accept(int var1) throws IOException, InterruptedException;

    protected boolean isAccepting() {
        return this.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionFactory getConnectionFactory(String protocol) {
        Map<String, ConnectionFactory> map = this._factories;
        synchronized (map) {
            return this._factories.get(protocol.toLowerCase(Locale.ENGLISH));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getConnectionFactory(Class<T> factoryType) {
        Map<String, ConnectionFactory> map = this._factories;
        synchronized (map) {
            for (ConnectionFactory f : this._factories.values()) {
                if (!factoryType.isAssignableFrom(f.getClass())) continue;
                return (T)f;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionFactory(ConnectionFactory factory) {
        Map<String, ConnectionFactory> map = this._factories;
        synchronized (map) {
            ConnectionFactory old = this._factories.remove(factory.getProtocol());
            if (old != null) {
                this.removeBean(old);
            }
            this._factories.put(factory.getProtocol().toLowerCase(Locale.ENGLISH), factory);
            this.addBean(factory);
            if (this._defaultProtocol == null) {
                this._defaultProtocol = factory.getProtocol();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionFactory removeConnectionFactory(String protocol) {
        Map<String, ConnectionFactory> map = this._factories;
        synchronized (map) {
            ConnectionFactory factory = this._factories.remove(protocol.toLowerCase(Locale.ENGLISH));
            this.removeBean(factory);
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ConnectionFactory> getConnectionFactories() {
        Map<String, ConnectionFactory> map = this._factories;
        synchronized (map) {
            return this._factories.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionFactories(Collection<ConnectionFactory> factories) {
        Map<String, ConnectionFactory> map = this._factories;
        synchronized (map) {
            ArrayList<ConnectionFactory> existing = new ArrayList<ConnectionFactory>(this._factories.values());
            for (ConnectionFactory factory : existing) {
                this.removeConnectionFactory(factory.getProtocol());
            }
            for (ConnectionFactory factory : factories) {
                if (factory == null) continue;
                this.addConnectionFactory(factory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManagedAttribute(value="Protocols supported by this connector")
    public List<String> getProtocols() {
        Map<String, ConnectionFactory> map = this._factories;
        synchronized (map) {
            return new ArrayList<String>(this._factories.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearConnectionFactories() {
        Map<String, ConnectionFactory> map = this._factories;
        synchronized (map) {
            this._factories.clear();
        }
    }

    @ManagedAttribute(value="This connector's default protocol")
    public String getDefaultProtocol() {
        return this._defaultProtocol;
    }

    public void setDefaultProtocol(String defaultProtocol) {
        this._defaultProtocol = defaultProtocol.toLowerCase(Locale.ENGLISH);
        if (this.isRunning()) {
            this._defaultConnectionFactory = this.getConnectionFactory(this._defaultProtocol);
        }
    }

    @Override
    public ConnectionFactory getDefaultConnectionFactory() {
        if (this.isStarted()) {
            return this._defaultConnectionFactory;
        }
        return this.getConnectionFactory(this._defaultProtocol);
    }

    @Override
    public Collection<EndPoint> getConnectedEndPoints() {
        return this._immutableEndPoints;
    }

    protected void onEndPointOpened(EndPoint endp) {
        this._endpoints.add(endp);
    }

    protected void onEndPointClosed(EndPoint endp) {
        this._endpoints.remove(endp);
    }

    @Override
    public Scheduler getScheduler() {
        return this._scheduler;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String toString() {
        return String.format("%s@%x{%s}", this._name == null ? this.getClass().getSimpleName() : this._name, this.hashCode(), this.getDefaultProtocol());
    }

    private class Acceptor
    implements Runnable {
        private final int _acceptor;

        private Acceptor(int id) {
            this._acceptor = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread current = Thread.currentThread();
            String name = current.getName();
            current.setName(name + "-acceptor-" + this._acceptor + "-" + AbstractConnector.this);
            AbstractConnector abstractConnector = AbstractConnector.this;
            synchronized (abstractConnector) {
                ((AbstractConnector)AbstractConnector.this)._acceptors[this._acceptor] = current;
            }
            try {
                while (AbstractConnector.this.isAccepting()) {
                    try {
                        AbstractConnector.this.accept(this._acceptor);
                    }
                    catch (Throwable e) {
                        if (AbstractConnector.this.isAccepting()) {
                            AbstractConnector.this.LOG.warn(e);
                            continue;
                        }
                        AbstractConnector.this.LOG.ignore(e);
                    }
                }
            }
            finally {
                current.setName(name);
                AbstractConnector e = AbstractConnector.this;
                synchronized (e) {
                    ((AbstractConnector)AbstractConnector.this)._acceptors[this._acceptor] = null;
                }
                CountDownLatch stopping = AbstractConnector.this._stopping;
                if (stopping != null) {
                    stopping.countDown();
                }
            }
        }
    }
}

