/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import org.apache.commons.io.IOUtils;

public final class Http {
    private Http() {
    }

    public static Response doGET(String uri) {
        return Http.http("GET", uri);
    }

    static Response http(String method, String uri) {
        try {
            URL url = new URL(uri);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(method);
            Object content = conn.getContent();
            if (content instanceof InputStream) {
                return new Response(conn.getResponseCode(), IOUtils.toString((InputStream)content, "UTF-8"));
            }
            if (content instanceof String) {
                return new Response(conn.getResponseCode(), (String)content);
            }
            return new Response(conn.getResponseCode(), "unknown");
        }
        catch (SocketException e) {
            return new Response(404);
        }
        catch (IOException e) {
            return new Response(500);
        }
    }

    public static Response doPOST(String uri) {
        return Http.http("POST", uri);
    }

    public static class Response {
        private final String body;
        private final int code;

        public Response(int code) {
            this(code, "");
        }

        public Response(int code, String body) {
            this.code = code;
            this.body = body;
        }
    }
}

