/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.server;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.esigate.server.EsigateServer;
import org.esigate.server.Http;

public class ControlHandler
extends AbstractHandler {
    private static final String PREFIX_CONTEXT = "org.eclipse.jetty.webapp.WebAppContext.main.";
    private static final String PREFIX_THREAD_POOL = "org.eclipse.jetty.util.thread.QueuedThreadPool.esigate.";
    private static final String URL_STATUS = "/server-status";
    private final MetricRegistry registry;

    public ControlHandler(MetricRegistry registry) {
        this.registry = registry;
    }

    private static boolean fromControlConnection(Request serverRequest) {
        return EsigateServer.getControlPort() == serverRequest.getLocalPort();
    }

    public static void shutdown(int port) {
        Http.doPOST("http://127.0.0.1:" + port + "/shutdown");
    }

    public static void status(int port) {
        Http.doGET("http://127.0.0.1:" + port + URL_STATUS);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void handle(String target, Request serverRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block32: {
            if (!ControlHandler.fromControlConnection(serverRequest)) break block32;
            serverRequest.setHandled(true);
            var5_5 = target;
            var6_6 = -1;
            switch (var5_5.hashCode()) {
                case 779642757: {
                    if (!var5_5.equals("/shutdown")) break;
                    var6_6 = 0;
                    break;
                }
                case 1709698541: {
                    if (!var5_5.equals("/server-status")) break;
                    var6_6 = 1;
                }
            }
            switch (var6_6) {
                case 0: {
                    if (!"POST".equals(serverRequest.getMethod())) break;
                    response.setStatus(200);
                    this.stopServer();
                    break;
                }
                case 1: {
                    if (!"GET".equals(serverRequest.getMethod())) break;
                    if (request.getParameter("auto") == null) ** GOTO lbl56
                    response.setStatus(200);
                    sos = response.getWriter();
                    var8_9 = null;
                    status = this.getServerStatus();
                    for (String key : status.keySet()) {
                        sos.append(key + ": " + status.get(key) + "\n");
                    }
                    if (sos == null) break;
                    if (var8_9 == null) ** GOTO lbl39
                    try {
                        sos.close();
                    }
                    catch (Throwable x2) {
                        var8_9.addSuppressed(x2);
                    }
                    break;
lbl39:
                    // 1 sources

                    sos.close();
                    break;
                    catch (Throwable x2) {
                        try {
                            var8_9 = x2;
                            throw x2;
                        }
                        catch (Throwable var12_21) {
                            if (sos != null) {
                                if (var8_9 != null) {
                                    try {
                                        sos.close();
                                    }
                                    catch (Throwable x2) {
                                        var8_9.addSuppressed(x2);
                                    }
                                } else {
                                    sos.close();
                                }
                            }
                            throw var12_21;
                        }
                    }
lbl56:
                    // 1 sources

                    response.setStatus(200);
                    sos = response.getWriter();
                    var8_10 = null;
                    sos.append("Esigate Server Status\n");
                    status = this.getServerStatus();
                    for (String key : status.keySet()) {
                        sos.append(key + ": " + status.get(key) + "\n");
                    }
                    if (sos == null) break;
                    if (var8_10 == null) ** GOTO lbl75
                    try {
                        sos.close();
                    }
                    catch (Throwable x2) {
                        var8_10.addSuppressed(x2);
                    }
                    break;
lbl75:
                    // 1 sources

                    sos.close();
                    break;
                    catch (Throwable var9_16) {
                        try {
                            var8_10 = var9_16;
                            throw var9_16;
                        }
                        catch (Throwable var14_23) {
                            if (sos != null) {
                                if (var8_10 != null) {
                                    try {
                                        sos.close();
                                    }
                                    catch (Throwable x2) {
                                        var8_10.addSuppressed(x2);
                                    }
                                } else {
                                    sos.close();
                                }
                            }
                            throw var14_23;
                        }
                    }
                }
                default: {
                    response.setStatus(406);
                }
            }
        }
    }

    private Map<String, Object> getServerStatus() {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        SortedMap<String, Counter> counters = this.registry.getCounters();
        for (Map.Entry c : counters.entrySet()) {
            result.put(ControlHandler.cleanupStatusKey((String)c.getKey()), String.valueOf(((Counter)c.getValue()).getCount()));
        }
        SortedMap<String, Meter> meters = this.registry.getMeters();
        for (Map.Entry c : meters.entrySet()) {
            result.put(ControlHandler.cleanupStatusKey((String)c.getKey()), String.valueOf(((Meter)c.getValue()).getCount()));
            result.put(ControlHandler.cleanupStatusKey((String)c.getKey()) + "PerSec", String.valueOf(((Meter)c.getValue()).getOneMinuteRate()));
        }
        SortedMap<String, Gauge> gauges = this.registry.getGauges();
        for (Map.Entry c : gauges.entrySet()) {
            result.put(ControlHandler.cleanupStatusKey((String)c.getKey()), String.valueOf(((Gauge)c.getValue()).getValue()));
        }
        SortedMap<String, Timer> timers = this.registry.getTimers();
        for (Map.Entry c : timers.entrySet()) {
            result.put(ControlHandler.cleanupStatusKey((String)c.getKey()), String.valueOf(((Timer)c.getValue()).getOneMinuteRate()));
        }
        Long accesses = new Long(((Meter)meters.get("org.eclipse.jetty.webapp.WebAppContext.main.1xx-responses")).getCount() + ((Meter)meters.get("org.eclipse.jetty.webapp.WebAppContext.main.2xx-responses")).getCount() + ((Meter)meters.get("org.eclipse.jetty.webapp.WebAppContext.main.3xx-responses")).getCount() + ((Meter)meters.get("org.eclipse.jetty.webapp.WebAppContext.main.4xx-responses")).getCount() + ((Meter)meters.get("org.eclipse.jetty.webapp.WebAppContext.main.5xx-responses")).getCount());
        result.put("Total Accesses", accesses);
        Double reqPerSec = new Double(((Meter)meters.get("org.eclipse.jetty.webapp.WebAppContext.main.1xx-responses")).getOneMinuteRate() + ((Meter)meters.get("org.eclipse.jetty.webapp.WebAppContext.main.2xx-responses")).getOneMinuteRate() + ((Meter)meters.get("org.eclipse.jetty.webapp.WebAppContext.main.3xx-responses")).getOneMinuteRate() + ((Meter)meters.get("org.eclipse.jetty.webapp.WebAppContext.main.4xx-responses")).getOneMinuteRate() + ((Meter)meters.get("org.eclipse.jetty.webapp.WebAppContext.main.5xx-responses")).getOneMinuteRate());
        result.put("ReqPerSec", reqPerSec);
        result.put("Uptime", new Long(ManagementFactory.getRuntimeMXBean().getUptime()));
        Double cpuLoad = new Double(ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage());
        if (cpuLoad >= 0.0) {
            result.put("CPULoad", cpuLoad);
        }
        return result;
    }

    private static String cleanupStatusKey(String s) {
        String result = s;
        if (s.startsWith(PREFIX_CONTEXT)) {
            result = s.substring(PREFIX_CONTEXT.length());
        }
        if (s.startsWith(PREFIX_THREAD_POOL)) {
            result = s.substring(PREFIX_THREAD_POOL.length());
        }
        return result;
    }

    private void stopServer() {
        final Server targetServer = this.getServer();
        new Thread(){

            @Override
            public void run() {
                try {
                    targetServer.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }
}

