/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.server.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class InstrumentedServerConnector
extends ServerConnector {
    private Meter accepts;
    private Meter connects;
    private Meter disconnects;
    private Counter connections;

    public InstrumentedServerConnector(String id, int port, @Name(value="server") Server server, MetricRegistry registry) {
        super(server);
        this.instrument(id, port, registry);
    }

    public InstrumentedServerConnector(String id, int port, @Name(value="server") Server server, MetricRegistry registry, ConnectionFactory ... factories) {
        super(server, factories);
        this.instrument(id, port, registry);
    }

    public InstrumentedServerConnector(String id, int port, @Name(value="server") Server server, @Name(value="sslContextFactory") SslContextFactory sslContextFactory, MetricRegistry registry) {
        super(server, sslContextFactory);
        this.instrument(id, port, registry);
    }

    @Override
    public void accept(int acceptorID) throws IOException {
        super.accept(acceptorID);
        this.accepts.mark();
    }

    @Override
    public void close() {
        super.close();
        this.disconnects.mark();
        this.connections.dec();
    }

    private void instrument(String id, int port, MetricRegistry registry) {
        this.setPort(port);
        this.accepts = registry.meter(id + "-accepts");
        this.connects = registry.meter(id + "-connects");
        this.disconnects = registry.meter(id + "-disconnects");
        this.connections = registry.counter(id + "-active-connections");
    }

    @Override
    public void open() throws IOException {
        this.connections.inc();
        super.open();
        this.connects.mark();
    }
}

