/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.refresh.RefreshAction;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.action.UpdateIndexMigrationVersionAction;
import org.elasticsearch.xpack.core.security.support.SecurityMigrationTaskParams;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;
import org.elasticsearch.xpack.security.support.SecurityMigrations;

public class SecurityMigrationExecutor
extends PersistentTasksExecutor<SecurityMigrationTaskParams> {
    private static final Logger logger = LogManager.getLogger(SecurityMigrationExecutor.class);
    private final SecurityIndexManager securityIndexManager;
    private final Client client;
    private final TreeMap<Integer, SecurityMigrations.SecurityMigration> migrationByVersion;

    public SecurityMigrationExecutor(String taskName, Executor executor, SecurityIndexManager securityIndexManager, Client client, TreeMap<Integer, SecurityMigrations.SecurityMigration> migrationByVersion) {
        super(taskName, executor);
        this.securityIndexManager = securityIndexManager;
        this.client = client;
        this.migrationByVersion = migrationByVersion;
    }

    protected void nodeOperation(AllocatedPersistentTask task, SecurityMigrationTaskParams params, PersistentTaskState state) {
        ActionListener listener = ActionListener.wrap(res -> task.markAsCompleted(), exception -> {
            logger.warn("Security migration failed: " + String.valueOf(exception));
            task.markAsFailed(exception);
        });
        if (!params.isMigrationNeeded()) {
            this.updateMigrationVersion(params.getMigrationVersion(), this.securityIndexManager.forCurrentProject().getConcreteIndexName(), (ActionListener<Void>)listener.delegateFailureAndWrap((l, response) -> {
                logger.info("Security migration not needed. Setting current version to: [" + params.getMigrationVersion() + "]");
                l.onResponse(response);
            }));
            return;
        }
        this.refreshSecurityIndex((ActionListener<Void>)new ThreadedActionListener(this.getExecutor(), listener.delegateFailureIgnoreResponseAndWrap(l -> this.applyOutstandingMigrations(task, params.getMigrationVersion(), (ActionListener<Void>)l))));
    }

    private void applyOutstandingMigrations(AllocatedPersistentTask task, int currentMigrationVersion, ActionListener<Void> migrationsListener) {
        if (task.isCancelled()) {
            migrationsListener.onFailure((Exception)new TaskCancelledException("Security migration task cancelled"));
            return;
        }
        Map.Entry<Integer, SecurityMigrations.SecurityMigration> migrationEntry = this.migrationByVersion.higherEntry(currentMigrationVersion);
        SecurityIndexManager.IndexState projectSecurityIndex = this.securityIndexManager.forCurrentProject();
        if (migrationEntry != null && projectSecurityIndex.isReadyForSecurityMigration(migrationEntry.getValue())) {
            migrationEntry.getValue().migrate(this.securityIndexManager, this.client, (ActionListener<Void>)migrationsListener.delegateFailureIgnoreResponseAndWrap(updateVersionListener -> this.updateMigrationVersion((Integer)migrationEntry.getKey(), projectSecurityIndex.getConcreteIndexName(), (ActionListener<Void>)new ThreadedActionListener(this.getExecutor(), updateVersionListener.delegateFailureIgnoreResponseAndWrap(refreshListener -> this.refreshSecurityIndex((ActionListener<Void>)new ThreadedActionListener(this.getExecutor(), refreshListener.delegateFailureIgnoreResponseAndWrap(l -> this.applyOutstandingMigrations(task, (Integer)migrationEntry.getKey(), (ActionListener<Void>)l)))))))));
        } else {
            logger.info("Security migrations applied until version: [" + currentMigrationVersion + "]");
            migrationsListener.onResponse(null);
        }
    }

    private void refreshSecurityIndex(ActionListener<Void> listener) {
        RefreshRequest refreshRequest = new RefreshRequest(new String[]{this.securityIndexManager.forCurrentProject().getConcreteIndexName()});
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)RefreshAction.INSTANCE, (ActionRequest)refreshRequest, (ActionListener)ActionListener.wrap(response -> {
            if (response.getFailedShards() != 0) {
                logger.warn("Failed to refresh security index during security migration {}", (Object)Arrays.toString(response.getShardFailures()));
            }
            listener.onResponse(null);
        }, exception -> {
            logger.warn("Failed to refresh security index during security migration", (Throwable)exception);
            listener.onResponse(null);
        }));
    }

    private void updateMigrationVersion(int migrationVersion, String indexName, ActionListener<Void> listener) {
        this.client.execute((ActionType)UpdateIndexMigrationVersionAction.INSTANCE, (ActionRequest)new UpdateIndexMigrationVersionAction.Request(TimeValue.MAX_VALUE, migrationVersion, indexName), listener.delegateFailureIgnoreResponseAndWrap(l -> l.onResponse(null)));
    }
}

