/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.rest.RestStatus;

public class FeatureNotEnabledException
extends ElasticsearchException {
    public static final String DISABLED_FEATURE_METADATA = "es.disabled.feature";

    public FeatureNotEnabledException(Feature feature, String message, Object ... args) {
        super(message, args);
        this.addMetadata(DISABLED_FEATURE_METADATA, new String[]{feature.featureName});
    }

    public RestStatus status() {
        return RestStatus.BAD_REQUEST;
    }

    public static enum Feature {
        TOKEN_SERVICE("security_tokens"),
        API_KEY_SERVICE("api_keys");

        private final String featureName;

        private Feature(String featureName) {
            this.featureName = featureName;
        }
    }
}

