/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.user;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.user.ProfileHasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.ProfileHasPrivilegesRequest;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

@ServerlessScope(value=Scope.INTERNAL)
public class RestProfileHasPrivilegesAction
extends SecurityBaseRestHandler {
    public RestProfileHasPrivilegesAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_security/profile/_has_privileges"), new RestHandler.Route(RestRequest.Method.POST, "/_security/profile/_has_privileges"));
    }

    public String getName() {
        return "security_profile_has_privileges_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        try (XContentParser parser = restRequest.contentOrSourceParamParser();){
            ProfileHasPrivilegesRequest request = (ProfileHasPrivilegesRequest)ProfileHasPrivilegesRequest.PARSER.parse(parser, null);
            HttpChannel httpChannel = restRequest.getHttpChannel();
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> new RestCancellableNodeClient(client, httpChannel).execute((ActionType)ProfileHasPrivilegesAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
            return restChannelConsumer;
        }
    }

    @Override
    protected Exception innerCheckFeatureAvailable(RestRequest request) {
        if (Security.USER_PROFILE_COLLABORATION_FEATURE.check(this.licenseState)) {
            return null;
        }
        return LicenseUtils.newComplianceException((String)Security.USER_PROFILE_COLLABORATION_FEATURE.getName());
    }
}

