/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import javax.net.ssl.SSLEngine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpServerChannel;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.nio.HttpReadWriteHandler;
import org.elasticsearch.http.nio.NioHttpChannel;
import org.elasticsearch.http.nio.NioHttpServerChannel;
import org.elasticsearch.http.nio.NioHttpServerTransport;
import org.elasticsearch.nio.BytesChannelContext;
import org.elasticsearch.nio.ChannelFactory;
import org.elasticsearch.nio.Config;
import org.elasticsearch.nio.InboundChannelBuffer;
import org.elasticsearch.nio.NioChannelHandler;
import org.elasticsearch.nio.NioSelector;
import org.elasticsearch.nio.NioServerSocketChannel;
import org.elasticsearch.nio.NioSocketChannel;
import org.elasticsearch.nio.Page;
import org.elasticsearch.nio.ServerChannelContext;
import org.elasticsearch.nio.SocketChannelContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.nio.NioGroupFactory;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.transport.SecurityHttpExceptionHandler;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;
import org.elasticsearch.xpack.security.transport.nio.NioIPFilter;
import org.elasticsearch.xpack.security.transport.nio.SSLChannelContext;
import org.elasticsearch.xpack.security.transport.nio.SSLDriver;

public class SecurityNioHttpServerTransport
extends NioHttpServerTransport {
    private static final Logger logger = LogManager.getLogger(SecurityNioHttpServerTransport.class);
    private final SecurityHttpExceptionHandler securityExceptionHandler;
    private final IPFilter ipFilter;
    private final SSLService sslService;
    private final SslConfiguration sslConfiguration;
    private final boolean sslEnabled;

    public SecurityNioHttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher, IPFilter ipFilter, SSLService sslService, NioGroupFactory nioGroupFactory, ClusterSettings clusterSettings) {
        super(settings, networkService, bigArrays, pageCacheRecycler, threadPool, xContentRegistry, dispatcher, nioGroupFactory, clusterSettings);
        this.securityExceptionHandler = new SecurityHttpExceptionHandler(logger, this.lifecycle, (c, e) -> super.onException(c, e));
        this.ipFilter = ipFilter;
        this.sslEnabled = (Boolean)XPackSettings.HTTP_SSL_ENABLED.get(settings);
        this.sslService = sslService;
        if (this.sslEnabled) {
            this.sslConfiguration = sslService.getHttpTransportSSLConfiguration();
            if (!sslService.isConfigurationValidForServerUsage(this.sslConfiguration)) {
                throw new IllegalArgumentException("a key must be provided to run as a server. the key should be configured using the [xpack.security.http.ssl.key] or [xpack.security.http.ssl.keystore.path] setting");
            }
        } else {
            this.sslConfiguration = null;
        }
    }

    protected void doStart() {
        super.doStart();
        this.ipFilter.setBoundHttpTransportAddress(this.boundAddress());
    }

    protected SecurityHttpChannelFactory channelFactory() {
        return new SecurityHttpChannelFactory();
    }

    class SecurityHttpChannelFactory
    extends ChannelFactory<NioHttpServerChannel, NioHttpChannel> {
        private SecurityHttpChannelFactory() {
            super(SecurityNioHttpServerTransport.this.tcpNoDelay, SecurityNioHttpServerTransport.this.tcpKeepAlive, SecurityNioHttpServerTransport.this.tcpKeepIdle, SecurityNioHttpServerTransport.this.tcpKeepInterval, SecurityNioHttpServerTransport.this.tcpKeepCount, SecurityNioHttpServerTransport.this.reuseAddress, SecurityNioHttpServerTransport.this.tcpSendBufferSize, SecurityNioHttpServerTransport.this.tcpReceiveBufferSize);
        }

        public NioHttpChannel createChannel(NioSelector selector, SocketChannel channel, Config.Socket socketConfig) throws IOException {
            Object context;
            NioHttpChannel httpChannel = new NioHttpChannel(channel);
            HttpReadWriteHandler httpHandler = new HttpReadWriteHandler(httpChannel, (NioHttpServerTransport)SecurityNioHttpServerTransport.this, SecurityNioHttpServerTransport.this.handlingSettings, selector.getTaskScheduler(), () -> ((ThreadPool)SecurityNioHttpServerTransport.this.threadPool).relativeTimeInNanos());
            Object handler = SecurityNioHttpServerTransport.this.ipFilter != null ? new NioIPFilter((NioChannelHandler)httpHandler, socketConfig.getRemoteAddress(), SecurityNioHttpServerTransport.this.ipFilter, ".http") : httpHandler;
            InboundChannelBuffer networkBuffer = new InboundChannelBuffer((IntFunction)SecurityNioHttpServerTransport.this.pageAllocator);
            Consumer<Exception> exceptionHandler = e -> SecurityNioHttpServerTransport.this.securityExceptionHandler.accept((HttpChannel)httpChannel, (Exception)e);
            if (SecurityNioHttpServerTransport.this.sslEnabled) {
                SSLEngine sslEngine;
                boolean hostnameVerificationEnabled = SecurityNioHttpServerTransport.this.sslConfiguration.verificationMode().isHostnameVerificationEnabled();
                if (hostnameVerificationEnabled) {
                    InetSocketAddress address = (InetSocketAddress)channel.getRemoteAddress();
                    sslEngine = SecurityNioHttpServerTransport.this.sslService.createSSLEngine(SecurityNioHttpServerTransport.this.sslConfiguration, address.getHostString(), address.getPort());
                } else {
                    sslEngine = SecurityNioHttpServerTransport.this.sslService.createSSLEngine(SecurityNioHttpServerTransport.this.sslConfiguration, null, -1);
                }
                SSLDriver sslDriver = new SSLDriver(sslEngine, (IntFunction<Page>)SecurityNioHttpServerTransport.this.pageAllocator, false);
                InboundChannelBuffer applicationBuffer = new InboundChannelBuffer((IntFunction)SecurityNioHttpServerTransport.this.pageAllocator);
                context = new SSLChannelContext((NioSocketChannel)httpChannel, selector, socketConfig, exceptionHandler, sslDriver, (NioChannelHandler)handler, networkBuffer, applicationBuffer);
            } else {
                context = new BytesChannelContext((NioSocketChannel)httpChannel, selector, socketConfig, exceptionHandler, (NioChannelHandler)handler, networkBuffer);
            }
            httpChannel.setContext((SocketChannelContext)context);
            return httpChannel;
        }

        public NioHttpServerChannel createServerChannel(NioSelector selector, ServerSocketChannel channel, Config.ServerSocket socketConfig) {
            NioHttpServerChannel httpServerChannel = new NioHttpServerChannel(channel);
            Consumer<Exception> exceptionHandler = e -> SecurityNioHttpServerTransport.this.onServerException((HttpServerChannel)httpServerChannel, e);
            Consumer<NioSocketChannel> acceptor = x$0 -> SecurityNioHttpServerTransport.this.acceptChannel(x$0);
            ServerChannelContext context = new ServerChannelContext((NioServerSocketChannel)httpServerChannel, (ChannelFactory)this, selector, socketConfig, acceptor, exceptionHandler);
            httpServerChannel.setContext(context);
            return httpServerChannel;
        }
    }
}

