/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.enrollment;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.common.ssl.SslKeyConfig;
import org.elasticsearch.common.ssl.SslUtil;
import org.elasticsearch.common.ssl.StoreKeyConfig;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.core.ssl.SSLService;

public class BaseEnrollmentTokenGenerator {
    public static final long ENROLL_API_KEY_EXPIRATION_MINUTES = 30L;

    static String getHttpsCaFingerprint(SSLService sslService) throws Exception {
        SslKeyConfig keyConfig = sslService.getHttpTransportSSLConfiguration().keyConfig();
        if (!(keyConfig instanceof StoreKeyConfig)) {
            throw new IllegalStateException("Unable to create an enrollment token. Elasticsearch node HTTP layer SSL configuration is not configured with a keystore");
        }
        List httpCaKeysAndCertificates = ((StoreKeyConfig)keyConfig).getKeys().stream().filter(t -> ((X509Certificate)t.v2()).getBasicConstraints() != -1).collect(Collectors.toList());
        if (httpCaKeysAndCertificates.isEmpty()) {
            throw new IllegalStateException("Unable to create an enrollment token. Elasticsearch node HTTP layer SSL configuration Keystore doesn't contain any PrivateKey entries where the associated certificate is a CA certificate");
        }
        if (httpCaKeysAndCertificates.size() > 1) {
            throw new IllegalStateException("Unable to create an enrollment token. Elasticsearch node HTTP layer SSL configuration Keystore contains multiple PrivateKey entries where the associated certificate is a CA certificate");
        }
        return SslUtil.calculateFingerprint((X509Certificate)((X509Certificate)((Tuple)httpCaKeysAndCertificates.get(0)).v2()), (String)"SHA-256");
    }

    static Tuple<List<String>, List<String>> splitAddresses(List<String> addresses) throws Exception {
        ArrayList<String> nonLocalAddresses = new ArrayList<String>();
        ArrayList<String> localAddresses = new ArrayList<String>();
        for (String boundAddress : addresses) {
            InetAddress inetAddress = BaseEnrollmentTokenGenerator.getInetAddressFromString(boundAddress);
            if (inetAddress.isLoopbackAddress()) {
                localAddresses.add(boundAddress);
                continue;
            }
            if (inetAddress.isAnyLocalAddress()) continue;
            nonLocalAddresses.add(boundAddress);
        }
        Comparator ipv4BeforeIpv6Comparator = (a, b) -> {
            try {
                InetAddress addressA = BaseEnrollmentTokenGenerator.getInetAddressFromString(a);
                InetAddress addressB = BaseEnrollmentTokenGenerator.getInetAddressFromString(b);
                if (addressA instanceof Inet4Address && addressB instanceof Inet6Address) {
                    return -1;
                }
                if (addressA instanceof Inet6Address && addressB instanceof Inet4Address) {
                    return 1;
                }
                return 0;
            }
            catch (Exception e) {
                return 0;
            }
        };
        localAddresses.sort(ipv4BeforeIpv6Comparator);
        nonLocalAddresses.sort(ipv4BeforeIpv6Comparator);
        List distinctLocalAddresses = localAddresses.stream().distinct().collect(Collectors.toUnmodifiableList());
        List distinctNonLocalAddresses = nonLocalAddresses.stream().distinct().collect(Collectors.toUnmodifiableList());
        return new Tuple(distinctLocalAddresses, distinctNonLocalAddresses);
    }

    static List<String> getFilteredAddresses(Tuple<List<String>, List<String>> splitAddresses) {
        if (((List)splitAddresses.v2()).isEmpty()) {
            return (List)splitAddresses.v1();
        }
        return (List)splitAddresses.v2();
    }

    static List<String> getFilteredAddresses(List<String> addresses) throws Exception {
        Tuple<List<String>, List<String>> splitAddresses = BaseEnrollmentTokenGenerator.splitAddresses(addresses);
        return BaseEnrollmentTokenGenerator.getFilteredAddresses(splitAddresses);
    }

    static String getIpFromPublishAddress(String publishAddress) {
        if (publishAddress.contains("/")) {
            return publishAddress.split("/")[1];
        }
        return publishAddress;
    }

    private static InetAddress getInetAddressFromString(String address) throws Exception {
        URI uri = new URI("http://" + address);
        return InetAddress.getByName(uri.getHost());
    }
}

