/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.time.Clock;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.security.authc.saml.SamlMessageBuilder;
import org.elasticsearch.xpack.security.authc.saml.SamlUtils;
import org.elasticsearch.xpack.security.authc.saml.SpConfiguration;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;

class SamlLogoutRequestMessageBuilder
extends SamlMessageBuilder {
    private final NameID nameId;
    private final String session;

    SamlLogoutRequestMessageBuilder(Clock clock, SpConfiguration serviceProvider, EntityDescriptor identityProvider, NameID nameId, String session) {
        super(identityProvider, serviceProvider, clock);
        this.nameId = nameId;
        this.session = session;
    }

    LogoutRequest build() {
        String logoutUrl = this.getLogoutUrl();
        if (Strings.isNullOrEmpty((String)logoutUrl)) {
            this.logger.debug("Cannot perform logout because the IDP {} does not provide a logout service", (Object)this.identityProvider.getEntityID());
            return null;
        }
        SessionIndex sessionIndex = SamlUtils.buildObject(SessionIndex.class, SessionIndex.DEFAULT_ELEMENT_NAME);
        sessionIndex.setValue(this.session);
        Issuer issuer = this.buildIssuer();
        LogoutRequest request = SamlUtils.buildObject(LogoutRequest.class, LogoutRequest.DEFAULT_ELEMENT_NAME);
        request.setID(this.buildId());
        request.setIssueInstant(this.clock.instant());
        request.setDestination(logoutUrl);
        request.setNameID(this.nameId);
        request.getSessionIndexes().add(sessionIndex);
        request.setIssuer(issuer);
        return request;
    }

    protected String getLogoutUrl() {
        return this.getIdentityProviderEndpoint("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", SSODescriptor::getSingleLogoutServices);
    }
}

