/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.user.DeleteUserRequest;
import org.elasticsearch.xpack.core.security.action.user.DeleteUserResponse;
import org.elasticsearch.xpack.core.security.authc.esnative.ClientReservedRealm;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;

public class TransportDeleteUserAction
extends HandledTransportAction<DeleteUserRequest, DeleteUserResponse> {
    private final Settings settings;
    private final NativeUsersStore usersStore;

    @Inject
    public TransportDeleteUserAction(Settings settings, ActionFilters actionFilters, NativeUsersStore usersStore, TransportService transportService) {
        super("cluster:admin/xpack/security/user/delete", transportService, actionFilters, DeleteUserRequest::new);
        this.settings = settings;
        this.usersStore = usersStore;
    }

    protected void doExecute(Task task, DeleteUserRequest request, ActionListener<DeleteUserResponse> listener) {
        String username = request.username();
        if (ClientReservedRealm.isReserved((String)username, (Settings)this.settings)) {
            if (AnonymousUser.isAnonymousUsername((String)username, (Settings)this.settings)) {
                listener.onFailure((Exception)new IllegalArgumentException("user [" + username + "] is anonymous and cannot be deleted"));
                return;
            }
            listener.onFailure((Exception)new IllegalArgumentException("user [" + username + "] is reserved and cannot be deleted"));
            return;
        }
        if (User.isInternalUsername((String)username)) {
            listener.onFailure((Exception)new IllegalArgumentException("user [" + username + "] is internal"));
            return;
        }
        this.usersStore.deleteUser(request, (ActionListener<Boolean>)listener.delegateFailure((l, found) -> l.onResponse((Object)new DeleteUserResponse(found.booleanValue()))));
    }
}

